/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.axis2.client.Options;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.ProtocolException;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties {
    public static final String PROP_MEX_TIMEOUT = "mex.timeout";
    public static final String PROP_P2P_MEX_TIMEOUT = "p2p.mex.timeout";
    public static final int DEFAULT_MEX_TIMEOUT = 120000;
    public static final String PROP_HTTP_CONNECTION_TIMEOUT = "http.connection.timeout";
    public static final String PROP_HTTP_SOCKET_TIMEOUT = "http.socket.timeout";
    public static final String PROP_HTTP_PROTOCOL_VERSION = "http.protocol.version";
    public static final String PROP_HTTP_HEADER_PREFIX = "http.default-headers.";
    public static final String PROP_HTTP_PROXY_PREFIX = "http.proxy.";
    public static final String PROP_HTTP_PROXY_HOST = "http.proxy.host";
    public static final String PROP_HTTP_PROXY_PORT = "http.proxy.port";
    public static final String PROP_HTTP_PROXY_DOMAIN = "http.proxy.domain";
    public static final String PROP_HTTP_PROXY_USER = "http.proxy.user";
    public static final String PROP_HTTP_PROXY_PASSWORD = "http.proxy.password";
    public static final String PROP_HTTP_PROTOCOL_ENCODING = "http.protocol.encoding";
    public static final String PROP_ADDRESS = "address";
    public static final String PROP_HTTP_MAX_REDIRECTS = "http.protocol.max-redirects";
    public static final String PROP_HTTP_REQUEST_CHUNK = "http.request.chunk";
    public static final String PROP_HTTP_REQUEST_GZIP = "http.request.gzip";
    public static final String PROP_HTTP_ACCEPT_GZIP = "http.accept.gzip";
    public static final String PROP_SECURITY_POLICY = "security.policy.file";
    public static final String PROP_JMS_REPLY_DESTINATION = "jms.reply.destination";
    public static final String PROP_JMS_REPLY_TIMEOUT = "jms.reply.timeout";
    public static final String PROP_JMS_DESTINATION_TYPE = "jms.destination.type";
    public static final String PROP_SEND_WS_ADDRESSING_HEADERS = "ws-addressing.headers";
    protected static final Log log = LogFactory.getLog(Properties.class);

    public static Object[] getProxyAndHeaders(Map<String, String> map) {
        ArrayList<Header> arrayList = null;
        HttpTransportProperties.ProxyProperties proxyProperties = null;
        Object object = map.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<String, String> entry = object.next();
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string.startsWith(PROP_HTTP_HEADER_PREFIX)) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Header>();
                }
                String string3 = string.substring(PROP_HTTP_HEADER_PREFIX.length());
                arrayList.add(new Header(string3, string2));
                continue;
            }
            if (!string.startsWith(PROP_HTTP_PROXY_PREFIX)) continue;
            if (proxyProperties == null) {
                proxyProperties = new HttpTransportProperties.ProxyProperties();
            }
            if (PROP_HTTP_PROXY_HOST.equals(string)) {
                proxyProperties.setProxyName(string2);
                continue;
            }
            if (PROP_HTTP_PROXY_PORT.equals(string)) {
                proxyProperties.setProxyPort(Integer.parseInt(string2));
                continue;
            }
            if (PROP_HTTP_PROXY_DOMAIN.equals(string)) {
                proxyProperties.setDomain(string2);
                continue;
            }
            if (PROP_HTTP_PROXY_USER.equals(string)) {
                proxyProperties.setUserName(string2);
                continue;
            }
            if (PROP_HTTP_PROXY_PASSWORD.equals(string)) {
                proxyProperties.setPassWord(string2);
                continue;
            }
            if (!log.isWarnEnabled()) continue;
            log.warn((Object)("Unknown proxy properties [" + string + "]. " + PROP_HTTP_PROXY_PREFIX + " is a refix reserved for proxy properties."));
        }
        if (proxyProperties != null && ((object = proxyProperties.getProxyHostName()) == null || ((String)object).length() == 0)) {
            proxyProperties = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Proxy host is null. Proxy will not be taken into account.");
            }
        }
        return new Object[]{proxyProperties, arrayList};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HttpClient {
        public static HttpParams translate(Map<String, String> map) {
            return HttpClient.translate(map, (HttpParams)new DefaultHttpParams());
        }

        public static HttpParams translate(Map<String, String> map, HttpParams httpParams) {
            Object object;
            block26: {
                block25: {
                    block24: {
                        block23: {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Translating Properties for HttpClient. Properties size=" + map.size()));
                            }
                            if (map.isEmpty()) {
                                return httpParams;
                            }
                            httpParams.setParameter("http.protocol.content-charset", (Object)"UTF-8");
                            for (Map.Entry<String, String> proxyProperties2 : map.entrySet()) {
                                httpParams.setParameter(proxyProperties2.getKey(), (Object)proxyProperties2.getValue());
                            }
                            httpParams.setParameter("http.default-headers", new ArrayList());
                            if (map.containsKey(Properties.PROP_HTTP_CONNECTION_TIMEOUT)) {
                                object = map.get(Properties.PROP_HTTP_CONNECTION_TIMEOUT);
                                try {
                                    httpParams.setParameter(Properties.PROP_HTTP_CONNECTION_TIMEOUT, (Object)Integer.valueOf((String)object));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    if (!log.isWarnEnabled()) break block23;
                                    log.warn((Object)("Mal-formatted Property: [http.connection.timeout=" + (String)object + "] Property will be skipped."));
                                }
                            }
                        }
                        if (map.containsKey(Properties.PROP_HTTP_SOCKET_TIMEOUT)) {
                            object = map.get(Properties.PROP_HTTP_SOCKET_TIMEOUT);
                            try {
                                httpParams.setParameter(Properties.PROP_HTTP_SOCKET_TIMEOUT, (Object)Integer.valueOf((String)object));
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (!log.isWarnEnabled()) break block24;
                                log.warn((Object)("Mal-formatted Property: [http.socket.timeout=" + (String)object + "] Property will be skipped."));
                            }
                        }
                    }
                    if (map.containsKey(Properties.PROP_HTTP_PROTOCOL_ENCODING)) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"Deprecated property: http.protocol.encoding. Use http.protocol.content-charset");
                        }
                        httpParams.setParameter("http.protocol.content-charset", (Object)map.get(Properties.PROP_HTTP_PROTOCOL_ENCODING));
                    }
                    if (map.containsKey("http.protocol.content-charset")) {
                        httpParams.setParameter("http.protocol.content-charset", (Object)map.get("http.protocol.content-charset"));
                    }
                    if (map.containsKey(Properties.PROP_HTTP_PROTOCOL_VERSION)) {
                        try {
                            httpParams.setParameter(Properties.PROP_HTTP_PROTOCOL_VERSION, (Object)HttpVersion.parse((String)map.get(Properties.PROP_HTTP_PROTOCOL_VERSION)));
                        }
                        catch (ProtocolException protocolException) {
                            if (!log.isWarnEnabled()) break block25;
                            log.warn((Object)"Mal-formatted Property: [http.protocol.version]", (Throwable)protocolException);
                        }
                    }
                }
                if (map.containsKey(Properties.PROP_HTTP_REQUEST_CHUNK)) {
                    httpParams.setBooleanParameter(Properties.PROP_HTTP_REQUEST_CHUNK, Boolean.parseBoolean(map.get(Properties.PROP_HTTP_REQUEST_CHUNK)));
                }
                if (map.containsKey(Properties.PROP_HTTP_REQUEST_GZIP) && log.isWarnEnabled()) {
                    log.warn((Object)"Property not supported by HTTP External Services: http.request.gzip");
                }
                if (Boolean.parseBoolean(map.get(Properties.PROP_HTTP_ACCEPT_GZIP)) && log.isWarnEnabled()) {
                    log.warn((Object)"Property not supported by HTTP External Services: http.accept.gzip");
                }
                if (map.containsKey(Properties.PROP_HTTP_MAX_REDIRECTS)) {
                    object = map.get(Properties.PROP_HTTP_MAX_REDIRECTS);
                    try {
                        httpParams.setParameter(Properties.PROP_HTTP_MAX_REDIRECTS, (Object)Integer.valueOf((String)object));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!log.isWarnEnabled()) break block26;
                        log.warn((Object)("Mal-formatted Property: [http.protocol.max-redirects=" + (String)object + "] Property will be skipped."));
                    }
                }
            }
            object = Properties.getProxyAndHeaders(map);
            HttpTransportProperties.ProxyProperties proxyProperties = (HttpTransportProperties.ProxyProperties)object[0];
            Collection collection = (Collection)object[1];
            if (collection != null && !collection.isEmpty()) {
                ((Collection)httpParams.getParameter("http.default-headers")).addAll(collection);
            }
            if (proxyProperties != null) {
                httpParams.setParameter(Properties.PROP_HTTP_PROXY_PREFIX, (Object)proxyProperties);
            }
            return new UnmodifiableHttpParams(httpParams);
        }

        static class UnmodifiableHttpParams
        implements HttpParams {
            final HttpParams p;

            private UnmodifiableHttpParams(HttpParams httpParams) {
                this.p = httpParams;
            }

            public void setBooleanParameter(String string, boolean bl) {
                throw new UnsupportedOperationException();
            }

            public void setDefaults(HttpParams httpParams) {
                throw new UnsupportedOperationException();
            }

            public void setDoubleParameter(String string, double d) {
                throw new UnsupportedOperationException();
            }

            public void setIntParameter(String string, int n) {
                throw new UnsupportedOperationException();
            }

            public void setLongParameter(String string, long l) {
                throw new UnsupportedOperationException();
            }

            public void setParameter(String string, Object object) {
                throw new UnsupportedOperationException();
            }

            public boolean getBooleanParameter(String string, boolean bl) {
                return this.p.getBooleanParameter(string, bl);
            }

            public HttpParams getDefaults() {
                return null;
            }

            public double getDoubleParameter(String string, double d) {
                return this.p.getDoubleParameter(string, d);
            }

            public int getIntParameter(String string, int n) {
                return this.p.getIntParameter(string, n);
            }

            public long getLongParameter(String string, long l) {
                return this.p.getLongParameter(string, l);
            }

            public Object getParameter(String string) {
                return this.p.getParameter(string);
            }

            public boolean isParameterFalse(String string) {
                return this.p.isParameterFalse(string);
            }

            public boolean isParameterSet(String string) {
                return this.p.isParameterSet(string);
            }

            public boolean isParameterSetLocally(String string) {
                return this.p.isParameterSetLocally(string);
            }

            public boolean isParameterTrue(String string) {
                return this.p.isParameterTrue(string);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Axis2 {
        public static Options translate(Map<String, String> map) {
            return Axis2.translate(map, new Options());
        }

        public static Options translate(Map<String, String> map, Options options) {
            HttpTransportProperties.ProxyProperties proxyProperties;
            Object object;
            block30: {
                block29: {
                    block28: {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Translating Properties for Axis2");
                        }
                        if (map.isEmpty()) {
                            return options;
                        }
                        options.setProperty("CHARACTER_SET_ENCODING", (Object)"UTF-8");
                        object = map.entrySet().iterator();
                        while (object.hasNext()) {
                            proxyProperties = object.next();
                            options.setProperty(proxyProperties.getKey(), (Object)proxyProperties.getValue());
                        }
                        if (map.containsKey(Properties.PROP_HTTP_CONNECTION_TIMEOUT)) {
                            object = map.get(Properties.PROP_HTTP_CONNECTION_TIMEOUT);
                            try {
                                options.setProperty("CONNECTION_TIMEOUT", (Object)Integer.valueOf((String)object));
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (!log.isWarnEnabled()) break block28;
                                log.warn((Object)("Mal-formatted Property: [http.connection.timeout=" + (String)object + "]. Integer expected. Property will be skipped."));
                            }
                        }
                    }
                    if (map.containsKey(Properties.PROP_HTTP_SOCKET_TIMEOUT)) {
                        object = map.get(Properties.PROP_HTTP_SOCKET_TIMEOUT);
                        try {
                            options.setProperty("SO_TIMEOUT", (Object)Integer.valueOf((String)object));
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (!log.isWarnEnabled()) break block29;
                            log.warn((Object)("Mal-formatted Property: [http.socket.timeout=" + (String)object + "]. Integer expected. Property will be skipped."));
                        }
                    }
                }
                if (map.containsKey(Properties.PROP_HTTP_PROTOCOL_ENCODING)) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Deprecated property: http.protocol.encoding. Use http.protocol.content-charset");
                    }
                    options.setProperty("CHARACTER_SET_ENCODING", (Object)map.get(Properties.PROP_HTTP_PROTOCOL_ENCODING));
                }
                if (map.containsKey("http.protocol.content-charset")) {
                    options.setProperty("CHARACTER_SET_ENCODING", (Object)map.get("http.protocol.content-charset"));
                }
                if (map.containsKey(Properties.PROP_HTTP_PROTOCOL_VERSION)) {
                    options.setProperty("__HTTP_PROTOCOL_VERSION__", (Object)map.get(Properties.PROP_HTTP_PROTOCOL_VERSION));
                }
                if (map.containsKey(Properties.PROP_HTTP_REQUEST_CHUNK)) {
                    options.setProperty("__CHUNKED__", (Object)map.get(Properties.PROP_HTTP_REQUEST_CHUNK));
                }
                if (map.containsKey(Properties.PROP_HTTP_REQUEST_GZIP)) {
                    options.setProperty("transport.http.gzipRequest", (Object)map.get(Properties.PROP_HTTP_REQUEST_GZIP));
                }
                if (map.containsKey(Properties.PROP_HTTP_ACCEPT_GZIP)) {
                    options.setProperty("transport.http.acceptGzip", (Object)map.get(Properties.PROP_HTTP_ACCEPT_GZIP));
                }
                if (map.containsKey(Properties.PROP_HTTP_MAX_REDIRECTS) && log.isWarnEnabled()) {
                    log.warn((Object)"Property Not Supported: http.protocol.max-redirects");
                }
                if (map.containsKey(Properties.PROP_JMS_REPLY_DESTINATION)) {
                    options.setProperty("transport.jms.ReplyDestination", (Object)map.get(Properties.PROP_JMS_REPLY_DESTINATION));
                }
                if (map.containsKey(Properties.PROP_JMS_REPLY_TIMEOUT)) {
                    object = map.get(Properties.PROP_JMS_REPLY_TIMEOUT);
                    options.setProperty("JMS_WAIT_REPLY", object);
                }
                if (map.containsKey(Properties.PROP_JMS_DESTINATION_TYPE)) {
                    object = map.get(Properties.PROP_JMS_DESTINATION_TYPE);
                    try {
                        options.setProperty("transport.jms.DestinationType", (Object)Long.valueOf((String)object));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!log.isWarnEnabled()) break block30;
                        log.warn((Object)("Mal-formatted Property: [jms.destination.type=" + (String)object + "]. Long expected. Property will be skipped."));
                    }
                }
            }
            if (map.containsKey(Properties.PROP_SEND_WS_ADDRESSING_HEADERS)) {
                object = map.get(Properties.PROP_SEND_WS_ADDRESSING_HEADERS);
                options.setProperty("disableAddressingForOutMessages", (Object)(!Boolean.parseBoolean((String)object) ? 1 : 0));
            }
            if (map.containsKey("ws-adddressing.headers")) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Deprecated property: ws-adddressing.headers (Mind the 3 d's). Use ws-addressing.headers");
                }
                options.setProperty("disableAddressingForOutMessages", (Object)(!Boolean.parseBoolean((String)(object = map.get("ws-adddressing.headers"))) ? 1 : 0));
            }
            object = Properties.getProxyAndHeaders(map);
            proxyProperties = (HttpTransportProperties.ProxyProperties)object[0];
            ArrayList arrayList = (ArrayList)object[1];
            if (arrayList != null && !arrayList.isEmpty()) {
                options.setProperty("HTTP_HEADERS", (Object)arrayList);
            }
            if (proxyProperties != null) {
                options.setProperty("PROXY", (Object)proxyProperties);
            }
            if (JavaUtils.isTrueExplicitly((Object)options.getProperty("REUSE_HTTP_CLIENT")) && log.isWarnEnabled()) {
                log.warn((Object)"This property cannot be overidden, and must always be false. REUSE_HTTP_CLIENT");
            }
            options.setProperty("REUSE_HTTP_CLIENT", (Object)"false");
            return options;
        }
    }
}

