/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class RelativeDateParser {
    private static final char YEAR_TEMPLATE_MODIFIER = 'y';
    private static final char MONTH_TEMPLATE_MODIFIER = 'M';
    private static final char WEEK_TEMPLATE_MODIFIER = 'w';
    private static final char DAY_TEMPLATE_MODIFIER = 'd';
    private static final char HOUR_TEMPLATE_MODIFIER = 'h';
    private static final char MINUTE_TEMPLATE_MODIFIER = 'm';
    private static final char SECOND_TEMPLATE_MODIFIER = 's';
    private static final char[] TEMPLATE_MODIFIERS_LIST = new char[]{'y', 'M', 'w', 'd', 'h', 'm', 's'};

    public static Date parseRelativeDate(String string) throws ParseException {
        int n;
        int n2;
        Object object;
        int[] nArray = new int[TEMPLATE_MODIFIERS_LIST.length];
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim());
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).length() < 2 || ((String)object).length() > 5) {
                throw new ParseException("Invalid token length. Token: " + (String)object, string.indexOf((String)object));
            }
            try {
                n2 = Integer.parseInt(((String)object).substring(0, ((String)object).length() - 1));
                if (n2 <= 0) {
                    throw new ParseException("Modifier value must be a positive number. Token: " + (String)object, string.indexOf((String)object));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Can't parse integer value. Token: " + (String)object, string.indexOf((String)object));
            }
            n = ((String)object).charAt(((String)object).length() - 1);
            while (true) {
                if (n3 >= TEMPLATE_MODIFIERS_LIST.length) {
                    throw new ParseException("Incorrect modifier at this position. Token: " + (String)object, string.indexOf((String)object) + ((String)object).length() - 1);
                }
                if (n == TEMPLATE_MODIFIERS_LIST[n3]) break;
                ++n3;
            }
            if (nArray[n3] != 0) {
                throw new ParseException("Dublicated modifier found. Token: " + (String)object, string.indexOf((String)object) + ((String)object).length() - 1);
            }
            nArray[n3++] = n2;
        }
        object = GregorianCalendar.getInstance();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] == 0) continue;
            n = RelativeDateParser.templateModifierIndexToCalendarField(n2);
            ((Calendar)object).add(n, 0 - nArray[n2]);
        }
        return ((Calendar)object).getTime();
    }

    private static int templateModifierIndexToCalendarField(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 12;
            }
            case 6: {
                return 13;
            }
        }
        throw new IllegalArgumentException("Invalid template modifier index: " + n);
    }
}

