/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.CommandlineSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Argument
implements CommandlineFragment {
    private String _argName;
    private String _description;
    private boolean _isOptional;
    private String _value;

    public Argument(String string, String string2, boolean bl) {
        this._argName = string;
        this._description = string2;
        this._isOptional = bl;
    }

    @Override
    public void reset() {
        this._value = null;
    }

    @Override
    public List<String> consume(List<String> list) throws CommandlineSyntaxException {
        if (list.size() == 0) {
            if (this._isOptional) {
                ArrayList<String> arrayList = new ArrayList<String>();
                Collections.copy(arrayList, list);
                return arrayList;
            }
            throw new CommandlineSyntaxException("The " + this._argName + " argument is required.");
        }
        ArrayList<String> arrayList = new ArrayList<String>(list);
        this._value = arrayList.remove(0);
        return arrayList;
    }

    @Override
    public boolean isOptional() {
        return this._isOptional;
    }

    public boolean isSet() {
        return this._value != null;
    }

    public String getValue() {
        return this._value;
    }

    @Override
    public String getUsage() {
        return "<" + this._argName + ">";
    }

    @Override
    public String getDescription() {
        return this._description;
    }
}

