/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.cli;

import java.util.ArrayList;
import java.util.List;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.CommandlineSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flag
implements CommandlineFragment {
    private String _name;
    private boolean _isSet;
    private String _description;
    private boolean _isOptional;

    public Flag(String string, String string2, boolean bl) {
        this._name = "-" + string;
        this._description = string2;
        this._isSet = false;
        this._isOptional = bl;
    }

    @Override
    public void reset() {
        this._isSet = false;
    }

    @Override
    public boolean isOptional() {
        return this._isOptional;
    }

    @Override
    public List<String> consume(List<String> list) throws CommandlineSyntaxException {
        this._isSet = list.contains(this._name);
        if (!this._isSet && !this._isOptional) {
            throw new CommandlineSyntaxException("The " + this._name + " flag is required.");
        }
        ArrayList<String> arrayList = new ArrayList<String>(list);
        arrayList.remove(this._name);
        if (arrayList.contains(this._name)) {
            throw new CommandlineSyntaxException("The " + this._name + " flag can appear at most once.");
        }
        return arrayList;
    }

    public boolean isSet() {
        return this._isSet;
    }

    @Override
    public String getUsage() {
        return this._name;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public boolean validate() {
        return true;
    }
}

