/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.util.scan;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.compiler.util.scan.AbstractSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaleSourceScanner
extends AbstractSourceInclusionScanner {
    private final long lastUpdatedWithinMsecs;
    private final Set<String> sourceIncludes;
    private final Set<String> sourceExcludes;

    public StaleSourceScanner() {
        this(0L, Collections.singleton("**/*"), Collections.emptySet());
    }

    public StaleSourceScanner(long lastUpdatedWithinMsecs) {
        this(lastUpdatedWithinMsecs, Collections.singleton("**/*"), Collections.emptySet());
    }

    public StaleSourceScanner(long lastUpdatedWithinMsecs, Set<String> sourceIncludes, Set<String> sourceExcludes) {
        this.lastUpdatedWithinMsecs = lastUpdatedWithinMsecs;
        this.sourceIncludes = sourceIncludes;
        this.sourceExcludes = sourceExcludes;
    }

    @Override
    public Set<File> getIncludedSources(File sourceDir, File targetDir) throws InclusionScanException {
        List<SourceMapping> srcMappings = this.getSourceMappings();
        if (srcMappings.isEmpty()) {
            return Collections.emptySet();
        }
        String[] potentialIncludes = this.scanForSources(sourceDir, this.sourceIncludes, this.sourceExcludes);
        HashSet<File> matchingSources = new HashSet<File>();
        block0: for (String path : potentialIncludes) {
            File sourceFile = new File(sourceDir, path);
            for (SourceMapping mapping : srcMappings) {
                Set<File> targetFiles = mapping.getTargetFiles(targetDir, path);
                for (File targetFile : targetFiles) {
                    if (targetFile.exists() && targetFile.lastModified() + this.lastUpdatedWithinMsecs >= sourceFile.lastModified()) continue;
                    matchingSources.add(sourceFile);
                    continue block0;
                }
            }
        }
        return matchingSources;
    }
}

