
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;group ref="{http://www.dmg.org/PMML-4_2}CONTINUOUS-DISTRIBUTION-TYPES"/>
 *         &lt;/choice>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "continuousDistribution"
})
@XmlRootElement(name = "Alternate", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_1)
public class Alternate
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "AnyDistribution", namespace = "http://www.dmg.org/PMML-4_2", type = AnyDistribution.class),
        @XmlElement(name = "GaussianDistribution", namespace = "http://www.dmg.org/PMML-4_2", type = GaussianDistribution.class),
        @XmlElement(name = "PoissonDistribution", namespace = "http://www.dmg.org/PMML-4_2", type = PoissonDistribution.class),
        @XmlElement(name = "UniformDistribution", namespace = "http://www.dmg.org/PMML-4_2", type = UniformDistribution.class)
    })
    private ContinuousDistribution continuousDistribution;

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the continuousDistribution property.
     * 
     * @return
     *     possible object is
     *     {@link AnyDistribution }
     *     {@link GaussianDistribution }
     *     {@link PoissonDistribution }
     *     {@link UniformDistribution }
     *     
     */
    public ContinuousDistribution getContinuousDistribution() {
        return continuousDistribution;
    }

    /**
     * Sets the value of the continuousDistribution property.
     * 
     * @param continuousDistribution
     *     allowed object is
     *     {@link AnyDistribution }
     *     {@link GaussianDistribution }
     *     {@link PoissonDistribution }
     *     {@link UniformDistribution }
     *     
     */
    public Alternate setContinuousDistribution(ContinuousDistribution continuousDistribution) {
        this.continuousDistribution = continuousDistribution;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Alternate addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getContinuousDistribution());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
