/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.domain;

import java.util.ArrayList;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.rest.domain.PropertySettingStrategy;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.test.TestGraphDatabaseFactory;

public class PropertySettingStrategyTest {
    private static GraphDatabaseAPI db;
    private Transaction tx;
    private static PropertySettingStrategy propSetter;

    @BeforeClass
    public static void createDb() {
        db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        propSetter = new PropertySettingStrategy(db);
    }

    @AfterClass
    public static void closeDb() {
        db.shutdown();
    }

    @Before
    public void beginTx() {
        this.tx = db.beginTx();
    }

    @After
    public void rollbackTx() {
        this.tx.close();
    }

    @Test
    public void shouldSetSingleProperty() throws Exception {
        Node node = db.createNode();
        propSetter.setProperty((PropertyContainer)node, "name", (Object)"bob");
        Assert.assertThat((Object)node.getProperty("name"), (Matcher)Matchers.is((Object)"bob"));
    }

    @Test
    public void shouldSetMultipleProperties() throws Exception {
        Node node = db.createNode();
        ArrayList<String> anArray = new ArrayList<String>();
        anArray.add("hello");
        anArray.add("Iamanarray");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("name", "bob");
        props.put("age", 12);
        props.put("anArray", anArray);
        propSetter.setProperties((PropertyContainer)node, props);
        Assert.assertThat((Object)node.getProperty("name"), (Matcher)Matchers.is((Object)"bob"));
        Assert.assertThat((Object)node.getProperty("age"), (Matcher)Matchers.is((Object)12));
        Assert.assertThat((Object)node.getProperty("anArray"), (Matcher)Matchers.is((Object)new String[]{"hello", "Iamanarray"}));
    }

    @Test
    public void shouldSetAllProperties() throws Exception {
        Node node = db.createNode();
        node.setProperty("name", (Object)"bob");
        node.setProperty("age", (Object)12);
        propSetter.setAllProperties((PropertyContainer)node, MapUtil.map((Object[])new Object[]{"name", "Steven", "color", 123}));
        Assert.assertThat((Object)node.getProperty("name"), (Matcher)Matchers.is((Object)"Steven"));
        Assert.assertThat((Object)node.getProperty("color"), (Matcher)Matchers.is((Object)123));
        Assert.assertThat((Object)node.hasProperty("age"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldNotFailSettingEmptyArrayIfEntityAlreadyHasAnEmptyArrayAsValue() throws Exception {
        Node node = db.createNode();
        node.setProperty("arr", (Object)new String[0]);
        propSetter.setProperty((PropertyContainer)node, "arr", new ArrayList());
        Assert.assertThat((Object)node.getProperty("arr"), (Matcher)Matchers.is((Object)new String[0]));
    }

    @Test
    public void shouldNotFailSettingEmptyArrayAndOtherValuesIfEntityAlreadyHasAnEmptyArrayAsValue() throws Exception {
        Node node = db.createNode();
        node.setProperty("arr", (Object)new String[0]);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("name", "bob");
        props.put("arr", new ArrayList());
        propSetter.setProperties((PropertyContainer)node, props);
        Assert.assertThat((Object)node.getProperty("name"), (Matcher)Matchers.is((Object)"bob"));
        Assert.assertThat((Object)node.getProperty("arr"), (Matcher)Matchers.is((Object)new String[0]));
    }

    @Test(expected=PropertyValueException.class)
    public void shouldThrowPropertyErrorWhenSettingEmptyArrayOnEntityWithNoPreExistingProperty() throws Exception {
        Node node = db.createNode();
        propSetter.setProperty((PropertyContainer)node, "arr", new ArrayList());
    }

    @Test(expected=PropertyValueException.class)
    public void shouldThrowPropertyErrorWhenSettingEmptyArrayOnEntityWithNoPreExistingEmptyArray() throws Exception {
        Node node = db.createNode();
        node.setProperty("arr", (Object)"hello");
        propSetter.setProperty((PropertyContainer)node, "arr", new ArrayList());
    }

    @Test
    public void shouldUseOriginalTypeWhenSettingEmptyArrayIfEntityAlreadyHasACollection() throws Exception {
        Node node = db.createNode();
        node.setProperty("arr", (Object)new String[]{"a", "b"});
        propSetter.setProperty((PropertyContainer)node, "arr", new ArrayList());
        Assert.assertThat((Object)node.getProperty("arr"), (Matcher)Matchers.is((Object)new String[0]));
    }

    @Test
    public void shouldUseOriginalTypeOnEmptyCollectionWhenSettingAllProperties() throws Exception {
        Node node = db.createNode();
        node.setProperty("name", (Object)"bob");
        node.setProperty("arr", (Object)new String[]{"a", "b"});
        propSetter.setAllProperties((PropertyContainer)node, MapUtil.map((Object[])new Object[]{"arr", new ArrayList()}));
        Assert.assertThat((Object)node.hasProperty("name"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)node.getProperty("arr"), (Matcher)Matchers.is((Object)new String[0]));
    }
}

