/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.Bookmark;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Session;

public class InternalDriver
implements Driver {
    private static final String DRIVER_LOG_NAME = "Driver";
    private final SecurityPlan securityPlan;
    private final SessionFactory sessionFactory;
    private final Logger log;
    private AtomicBoolean closed = new AtomicBoolean(false);

    InternalDriver(SecurityPlan securityPlan, SessionFactory sessionFactory, Logging logging) {
        this.securityPlan = securityPlan;
        this.sessionFactory = sessionFactory;
        this.log = logging.getLog(DRIVER_LOG_NAME);
    }

    @Override
    public final boolean isEncrypted() {
        this.assertOpen();
        return this.securityPlan.requiresEncryption();
    }

    @Override
    public final Session session() {
        return this.session(AccessMode.WRITE);
    }

    @Override
    public final Session session(AccessMode mode) {
        return this.newSession(mode, Bookmark.empty());
    }

    @Override
    public final Session session(String bookmark) {
        return this.session(AccessMode.WRITE, bookmark);
    }

    @Override
    public final Session session(AccessMode mode, String bookmark) {
        return this.newSession(mode, Bookmark.from(bookmark));
    }

    @Override
    public Session session(Iterable<String> bookmarks) {
        return this.session(AccessMode.WRITE, bookmarks);
    }

    @Override
    public Session session(AccessMode mode, Iterable<String> bookmarks) {
        return this.newSession(mode, Bookmark.from(bookmarks));
    }

    private Session newSession(AccessMode mode, Bookmark bookmark) {
        this.assertOpen();
        Session session = this.sessionFactory.newInstance(mode, bookmark);
        if (this.closed.get()) {
            this.closeResources();
            throw InternalDriver.driverCloseException();
        }
        return session;
    }

    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.closeResources();
        }
    }

    public final SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    private void closeResources() {
        try {
            this.sessionFactory.close();
        }
        catch (Exception ex) {
            this.log.error(String.format("~~ [ERROR] %s", ex.getMessage()), ex);
        }
    }

    private void assertOpen() {
        if (this.closed.get()) {
            throw InternalDriver.driverCloseException();
        }
    }

    private static RuntimeException driverCloseException() {
        return new IllegalStateException("This driver instance has already been closed");
    }
}

