/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.transport.BoltProtocolPipelineInstaller;
import org.neo4j.bolt.transport.BoltProtocolPipelineInstallerFactory;
import org.neo4j.bolt.transport.DefaultBoltProtocolPipelineInstaller;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.Neo4jPackV1;
import org.neo4j.bolt.v2.messaging.Neo4jPackV2;
import org.neo4j.kernel.impl.logging.LogService;

public class DefaultBoltProtocolPipelineInstallerFactory
implements BoltProtocolPipelineInstallerFactory {
    private final BoltConnectionFactory connectionFactory;
    private final TransportThrottleGroup throttleGroup;
    private final LogService logService;

    public DefaultBoltProtocolPipelineInstallerFactory(BoltConnectionFactory connectionFactory, TransportThrottleGroup throttleGroup, LogService logService) {
        this.connectionFactory = connectionFactory;
        this.throttleGroup = throttleGroup;
        this.logService = logService;
    }

    @Override
    public BoltProtocolPipelineInstaller create(long protocolVersion, BoltChannel channel) {
        if (protocolVersion == 1L) {
            return this.newProtocolPipelineInstaller(channel, new Neo4jPackV1());
        }
        if (protocolVersion == 2L) {
            return this.newProtocolPipelineInstaller(channel, new Neo4jPackV2());
        }
        return null;
    }

    private BoltProtocolPipelineInstaller newProtocolPipelineInstaller(BoltChannel channel, Neo4jPack neo4jPack) {
        return new DefaultBoltProtocolPipelineInstaller(channel, this.newBoltConnection(channel), neo4jPack, this.throttleGroup, this.logService);
    }

    private BoltConnection newBoltConnection(BoltChannel channel) {
        return this.connectionFactory.newConnection(channel);
    }
}

