/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.neo4j.bolt.v1.messaging.BoltIOException;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.packstream.ByteBufInput;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;

public class MessageDecoder
extends SimpleChannelInboundHandler<ByteBuf> {
    private final ByteBufInput input = new ByteBufInput();
    private final BoltRequestMessageReader reader;
    private final BoltRequestMessageHandler messageHandler;
    private final Log log;

    public MessageDecoder(Neo4jPack pack, BoltRequestMessageHandler messageHandler, LogService logService) {
        this.reader = new BoltRequestMessageReader(pack.newUnpacker(this.input));
        this.messageHandler = messageHandler;
        this.log = logService.getInternalLog(((Object)((Object)this)).getClass());
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws Exception {
        block8: {
            this.input.start(byteBuf);
            byteBuf.markReaderIndex();
            try {
                this.reader.read(this.messageHandler);
            }
            catch (BoltIOException ex) {
                if (ex.causesFailureMessage()) {
                    this.messageHandler.onExternalError(Neo4jError.from(ex));
                    break block8;
                }
                this.logMessageOnError(byteBuf);
                throw ex;
            }
            catch (Throwable error) {
                this.logMessageOnError(byteBuf);
                throw error;
            }
            finally {
                this.input.stop();
            }
        }
    }

    private void logMessageOnError(ByteBuf byteBuf) {
        byteBuf.resetReaderIndex();
        this.log.error("Failed to read an inbound message:\n" + ByteBufUtil.hexDump((ByteBuf)byteBuf) + '\n');
    }
}

