/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.CatchupServerProtocol;
import org.neo4j.causalclustering.catchup.ResponseMessageType;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreFileRequest;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyRequestHandler;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreamingProtocol;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.causalclustering.messaging.StoreCopyRequest;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.StoreFileMetadata;

public class StoreCopyRequestHandlerTest {
    private static final StoreId STORE_ID_MISMATCHING = new StoreId(1L, 1L, 1L, 1L);
    private static final StoreId STORE_ID_MATCHING = new StoreId(1L, 2L, 3L, 4L);
    private final DefaultFileSystemAbstraction fileSystemAbstraction = new DefaultFileSystemAbstraction();
    private final NeoStoreDataSource neoStoreDataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
    private final CheckPointer checkPointer = new FakeCheckPointer();
    private final PageCache pageCache = (PageCache)Mockito.mock(PageCache.class);
    private EmbeddedChannel embeddedChannel;
    private CatchupServerProtocol catchupServerProtocol;

    @Before
    public void setup() {
        this.catchupServerProtocol = new CatchupServerProtocol();
        this.catchupServerProtocol.expect((Enum)CatchupServerProtocol.State.GET_STORE_FILE);
        NiceStoreCopyRequestHandler storeCopyRequestHandler = new NiceStoreCopyRequestHandler(this.catchupServerProtocol, () -> this.neoStoreDataSource, () -> this.checkPointer, new StoreFileStreamingProtocol(), this.pageCache, (FileSystemAbstraction)this.fileSystemAbstraction, (LogProvider)NullLogProvider.getInstance());
        Mockito.when((Object)this.neoStoreDataSource.getStoreId()).thenReturn((Object)new org.neo4j.kernel.impl.store.StoreId(1L, 2L, 5L, 3L, 4L));
        this.embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{storeCopyRequestHandler});
    }

    @Test
    public void shouldGiveProperErrorOnStoreIdMismatch() {
        this.embeddedChannel.writeInbound(new Object[]{new GetStoreFileRequest(STORE_ID_MISMATCHING, new File("some-file"), 1L)});
        Assert.assertEquals((Object)ResponseMessageType.STORE_COPY_FINISHED, (Object)this.embeddedChannel.readOutbound());
        StoreCopyFinishedResponse expectedResponse = new StoreCopyFinishedResponse(StoreCopyFinishedResponse.Status.E_STORE_ID_MISMATCH);
        Assert.assertEquals((Object)expectedResponse, (Object)this.embeddedChannel.readOutbound());
        Assert.assertTrue((boolean)this.catchupServerProtocol.isExpecting((Enum)CatchupServerProtocol.State.MESSAGE_TYPE));
    }

    @Test
    public void shouldGiveProperErrorOnTxBehind() {
        this.embeddedChannel.writeInbound(new Object[]{new GetStoreFileRequest(STORE_ID_MATCHING, new File("some-file"), 2L)});
        Assert.assertEquals((Object)ResponseMessageType.STORE_COPY_FINISHED, (Object)this.embeddedChannel.readOutbound());
        StoreCopyFinishedResponse expectedResponse = new StoreCopyFinishedResponse(StoreCopyFinishedResponse.Status.E_TOO_FAR_BEHIND);
        Assert.assertEquals((Object)expectedResponse, (Object)this.embeddedChannel.readOutbound());
        Assert.assertTrue((boolean)this.catchupServerProtocol.isExpecting((Enum)CatchupServerProtocol.State.MESSAGE_TYPE));
    }

    @Test
    public void shouldResetProtocolAndGiveErrorOnUncheckedException() {
        Mockito.when((Object)this.neoStoreDataSource.getStoreId()).thenThrow(new Throwable[]{new IllegalStateException()});
        try {
            this.embeddedChannel.writeInbound(new Object[]{new GetStoreFileRequest(STORE_ID_MATCHING, new File("some-file"), 1L)});
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)ResponseMessageType.STORE_COPY_FINISHED, (Object)this.embeddedChannel.readOutbound());
        StoreCopyFinishedResponse expectedResponse = new StoreCopyFinishedResponse(StoreCopyFinishedResponse.Status.E_UNKNOWN);
        Assert.assertEquals((Object)expectedResponse, (Object)this.embeddedChannel.readOutbound());
        Assert.assertTrue((boolean)this.catchupServerProtocol.isExpecting((Enum)CatchupServerProtocol.State.MESSAGE_TYPE));
    }

    @Test
    public void shoulResetProtoclAndGiveErrorIfFilesThrowException() {
        EmbeddedChannel alternativeChannel = new EmbeddedChannel(new ChannelHandler[]{new EvilStoreCopyRequestHandler(this.catchupServerProtocol, () -> this.neoStoreDataSource, () -> this.checkPointer, new StoreFileStreamingProtocol(), this.pageCache, (FileSystemAbstraction)this.fileSystemAbstraction, (LogProvider)NullLogProvider.getInstance())});
        try {
            alternativeChannel.writeInbound(new Object[]{new GetStoreFileRequest(STORE_ID_MATCHING, new File("some-file"), 1L)});
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)ResponseMessageType.STORE_COPY_FINISHED, (Object)alternativeChannel.readOutbound());
        StoreCopyFinishedResponse expectedResponse = new StoreCopyFinishedResponse(StoreCopyFinishedResponse.Status.E_UNKNOWN);
        Assert.assertEquals((Object)expectedResponse, (Object)alternativeChannel.readOutbound());
        Assert.assertTrue((boolean)this.catchupServerProtocol.isExpecting((Enum)CatchupServerProtocol.State.MESSAGE_TYPE));
    }

    private class FakeCheckPointer
    implements CheckPointer {
        private FakeCheckPointer() {
        }

        public long checkPointIfNeeded(TriggerInfo triggerInfo) {
            return 1L;
        }

        public long tryCheckPoint(TriggerInfo triggerInfo) {
            return 1L;
        }

        public long forceCheckPoint(TriggerInfo triggerInfo) {
            return 1L;
        }

        public long lastCheckPointedTransactionId() {
            return 1L;
        }
    }

    private class EvilStoreCopyRequestHandler
    extends StoreCopyRequestHandler<StoreCopyRequest> {
        private EvilStoreCopyRequestHandler(CatchupServerProtocol protocol, Supplier<NeoStoreDataSource> dataSource, Supplier<CheckPointer> checkpointerSupplier, StoreFileStreamingProtocol storeFileStreamingProtocol, PageCache pageCache, FileSystemAbstraction fs, LogProvider logProvider) {
            super(protocol, dataSource, checkpointerSupplier, storeFileStreamingProtocol, pageCache, fs, logProvider);
        }

        ResourceIterator<StoreFileMetadata> files(StoreCopyRequest request, NeoStoreDataSource neoStoreDataSource) throws IOException {
            throw new IllegalStateException("I am evil");
        }
    }

    private class NiceStoreCopyRequestHandler
    extends StoreCopyRequestHandler<StoreCopyRequest> {
        private NiceStoreCopyRequestHandler(CatchupServerProtocol protocol, Supplier<NeoStoreDataSource> dataSource, Supplier<CheckPointer> checkpointerSupplier, StoreFileStreamingProtocol storeFileStreamingProtocol, PageCache pageCache, FileSystemAbstraction fs, LogProvider logProvider) {
            super(protocol, dataSource, checkpointerSupplier, storeFileStreamingProtocol, pageCache, fs, logProvider);
        }

        ResourceIterator<StoreFileMetadata> files(StoreCopyRequest request, NeoStoreDataSource neoStoreDataSource) throws IOException {
            return Iterators.emptyResourceIterator();
        }
    }
}

