/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import io.netty.buffer.ByteBufAllocator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.CatchupServerProtocol;
import org.neo4j.causalclustering.catchup.ResponseMessageType;
import org.neo4j.causalclustering.catchup.tx.ChunkedTransactionStream;
import org.neo4j.causalclustering.catchup.tx.TxPullResponse;
import org.neo4j.causalclustering.catchup.tx.TxStreamFinishedResponse;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.cursor.IOCursor;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;

public class ChunkedTransactionStreamTest {
    @Test
    public void shouldStreamTransactions() throws Exception {
        StoreId storeId = StoreId.DEFAULT;
        IOCursor cursor = (IOCursor)Mockito.mock(IOCursor.class);
        ChunkedTransactionStream txStream = new ChunkedTransactionStream(storeId, 2L, cursor, (CatchupServerProtocol)Mockito.mock(CatchupServerProtocol.class));
        ByteBufAllocator allocator = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);
        CommittedTransactionRepresentation tx1 = this.tx(2L);
        CommittedTransactionRepresentation tx2 = this.tx(3L);
        CommittedTransactionRepresentation tx3 = this.tx(4L);
        long lastTxId = 4L;
        Mockito.when((Object)cursor.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)cursor.get()).thenReturn((Object)tx1, (Object[])new CommittedTransactionRepresentation[]{tx2, tx3});
        Assert.assertFalse((boolean)txStream.isEndOfInput());
        Assert.assertEquals((Object)ResponseMessageType.TX, (Object)txStream.readChunk(allocator));
        Assert.assertEquals((Object)new TxPullResponse(storeId, tx1), (Object)txStream.readChunk(allocator));
        Assert.assertEquals((Object)ResponseMessageType.TX, (Object)txStream.readChunk(allocator));
        Assert.assertEquals((Object)new TxPullResponse(storeId, tx2), (Object)txStream.readChunk(allocator));
        Assert.assertEquals((Object)ResponseMessageType.TX, (Object)txStream.readChunk(allocator));
        Assert.assertEquals((Object)new TxPullResponse(storeId, tx3), (Object)txStream.readChunk(allocator));
        Assert.assertEquals((Object)ResponseMessageType.TX_STREAM_FINISHED, (Object)txStream.readChunk(allocator));
        Assert.assertEquals((Object)new TxStreamFinishedResponse(CatchupResult.SUCCESS_END_OF_STREAM, lastTxId), (Object)txStream.readChunk(allocator));
        Assert.assertTrue((boolean)txStream.isEndOfInput());
        txStream.close();
        ((IOCursor)Mockito.verify((Object)cursor)).close();
    }

    private CommittedTransactionRepresentation tx(long txId) {
        CommittedTransactionRepresentation tx = (CommittedTransactionRepresentation)Mockito.mock(CommittedTransactionRepresentation.class);
        Mockito.when((Object)tx.getCommitEntry()).thenReturn((Object)new LogEntryCommit(txId, 0L));
        return tx;
    }
}

