/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.election;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.election.ElectionUtil;
import org.neo4j.causalclustering.core.consensus.election.Fixture;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.collection.FilteringIterable;

public class DisconnectLeaderScenario {
    private final Fixture fixture;
    private final long electionTimeout;
    private final List<Long> electionTimeResults = new ArrayList<Long>();
    private long timeoutCount;

    public DisconnectLeaderScenario(Fixture fixture, long electionTimeout) {
        this.fixture = fixture;
        this.electionTimeout = electionTimeout;
    }

    public void run(long iterations, long leaderStabilityMaxTimeMillis) throws InterruptedException {
        int i = 0;
        while ((long)i < iterations) {
            try {
                long electionTime = this.oneIteration(leaderStabilityMaxTimeMillis);
                this.electionTimeResults.add(electionTime);
            }
            catch (TimeoutException e) {
                ++this.timeoutCount;
            }
            this.fixture.net.reset();
            Thread.sleep(ThreadLocalRandom.current().nextLong(this.electionTimeout));
            ++i;
        }
    }

    private long oneIteration(long leaderStabilityMaxTimeMillis) throws InterruptedException, TimeoutException {
        List<RaftMachine> rafts = this.fixture.rafts.stream().map(Fixture.RaftFixture::raftMachine).collect(Collectors.toList());
        MemberId oldLeader = ElectionUtil.waitForLeaderAgreement(rafts, leaderStabilityMaxTimeMillis);
        long startTime = System.currentTimeMillis();
        this.fixture.net.disconnect(oldLeader);
        MemberId newLeader = ElectionUtil.waitForLeaderAgreement((Iterable<RaftMachine>)new FilteringIterable(rafts, raft -> !raft.identity().equals((Object)oldLeader)), leaderStabilityMaxTimeMillis);
        assert (!newLeader.equals((Object)oldLeader));
        return System.currentTimeMillis() - startTime;
    }

    private boolean hadOneOrMoreCollisions(long result) {
        return result > this.electionTimeout * 2L;
    }

    public Result result() {
        Result result = new Result();
        long collidingRuns = 0L;
        long collidingSum = 0L;
        long nonCollidingRuns = 0L;
        long nonCollidingSum = 0L;
        for (long electionTime : this.electionTimeResults) {
            if (this.hadOneOrMoreCollisions(electionTime)) {
                ++collidingRuns;
                collidingSum += electionTime;
                continue;
            }
            ++nonCollidingRuns;
            nonCollidingSum += electionTime;
        }
        result.collidingAverage = (double)collidingSum / (double)collidingRuns;
        result.nonCollidingAverage = (double)nonCollidingSum / (double)nonCollidingRuns;
        result.collisionRate = (double)collidingRuns / (double)this.electionTimeResults.size();
        result.collisionCount = collidingRuns;
        result.timeoutCount = this.timeoutCount;
        return result;
    }

    public class Result {
        double nonCollidingAverage;
        double collidingAverage;
        double collisionRate;
        long collisionCount;
        long timeoutCount;

        public String toString() {
            return String.format("Result{nonCollidingAverage=%s, collidingAverage=%s, collisionRate=%s, collisionCount=%d, timeoutCount=%d}", this.nonCollidingAverage, this.collidingAverage, this.collisionRate, this.collisionCount, this.timeoutCount);
        }
    }
}

