/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.schedule;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.causalclustering.core.consensus.schedule.TimeoutHandler;
import org.neo4j.causalclustering.core.consensus.schedule.Timer;
import org.neo4j.causalclustering.core.consensus.schedule.TimerService;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;

public class CountingTimerService
extends TimerService {
    private final Map<String, Long> counts = new HashMap<String, Long>();

    public CountingTimerService(JobScheduler scheduler, LogProvider logProvider) {
        super(scheduler, logProvider);
    }

    public Timer create(TimerService.TimerName name, JobScheduler.Group group, TimeoutHandler handler) {
        TimeoutHandler countingHandler = timer -> {
            long count = this.counts.getOrDefault(name.name(), 0L);
            this.counts.put(name.name(), count + 1L);
            handler.onTimeout(timer);
        };
        return super.create(name, group, countingHandler);
    }

    public long invocationCount(TimerService.TimerName name) {
        return this.counts.getOrDefault(name.name(), 0L);
    }
}

