/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.schedule;

import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.consensus.schedule.TimeoutFactory;
import org.neo4j.causalclustering.core.consensus.schedule.TimeoutHandler;
import org.neo4j.causalclustering.core.consensus.schedule.Timer;
import org.neo4j.causalclustering.core.consensus.schedule.TimerService;
import org.neo4j.kernel.impl.scheduler.CentralJobScheduler;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.FakeClockJobScheduler;

public class TimerServiceTest {
    private final JobScheduler.Group group = new JobScheduler.Group("Test");
    private final TimeoutHandler handlerA = (TimeoutHandler)Mockito.mock(TimeoutHandler.class);
    private final TimeoutHandler handlerB = (TimeoutHandler)Mockito.mock(TimeoutHandler.class);
    private final FakeClockJobScheduler scheduler = new FakeClockJobScheduler();
    private final TimerService timerService = new TimerService((JobScheduler)this.scheduler, (LogProvider)NullLogProvider.getInstance());
    private final Timer timerA = this.timerService.create((TimerService.TimerName)Timers.TIMER_A, this.group, this.handlerA);
    private final Timer timerB = this.timerService.create((TimerService.TimerName)Timers.TIMER_B, this.group, this.handlerB);

    @Test
    public void shouldNotInvokeHandlerBeforeTimeout() throws Exception {
        this.timerA.set(TimeoutFactory.fixedTimeout((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS));
        this.scheduler.forward(999L, TimeUnit.MILLISECONDS);
        ((TimeoutHandler)Mockito.verify((Object)this.handlerA, (VerificationMode)Mockito.never())).onTimeout((Timer)ArgumentMatchers.any());
    }

    @Test
    public void shouldInvokeHandlerOnTimeout() throws Exception {
        this.timerA.set(TimeoutFactory.fixedTimeout((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS));
        this.scheduler.forward(1000L, TimeUnit.MILLISECONDS);
        ((TimeoutHandler)Mockito.verify((Object)this.handlerA, (VerificationMode)Mockito.times((int)1))).onTimeout((Timer)ArgumentMatchers.any());
    }

    @Test
    public void shouldInvokeHandlerAfterTimeout() throws Exception {
        this.timerA.set(TimeoutFactory.fixedTimeout((long)1L, (TimeUnit)TimeUnit.SECONDS));
        this.scheduler.forward(1001L, TimeUnit.MILLISECONDS);
        ((TimeoutHandler)Mockito.verify((Object)this.handlerA, (VerificationMode)Mockito.times((int)1))).onTimeout((Timer)ArgumentMatchers.any());
    }

    @Test
    public void shouldInvokeMultipleHandlersOnDifferentTimeouts() throws Exception {
        this.timerA.set(TimeoutFactory.fixedTimeout((long)1L, (TimeUnit)TimeUnit.SECONDS));
        this.timerB.set(TimeoutFactory.fixedTimeout((long)2L, (TimeUnit)TimeUnit.SECONDS));
        this.scheduler.forward(1L, TimeUnit.SECONDS);
        ((TimeoutHandler)Mockito.verify((Object)this.handlerA, (VerificationMode)Mockito.times((int)1))).onTimeout(this.timerA);
        ((TimeoutHandler)Mockito.verify((Object)this.handlerB, (VerificationMode)Mockito.never())).onTimeout((Timer)ArgumentMatchers.any());
        Mockito.reset((Object[])new TimeoutHandler[]{this.handlerA});
        Mockito.reset((Object[])new TimeoutHandler[]{this.handlerB});
        this.scheduler.forward(1L, TimeUnit.SECONDS);
        ((TimeoutHandler)Mockito.verify((Object)this.handlerA, (VerificationMode)Mockito.never())).onTimeout((Timer)ArgumentMatchers.any());
        ((TimeoutHandler)Mockito.verify((Object)this.handlerB, (VerificationMode)Mockito.times((int)1))).onTimeout(this.timerB);
        Mockito.reset((Object[])new TimeoutHandler[]{this.handlerA});
        Mockito.reset((Object[])new TimeoutHandler[]{this.handlerB});
        this.scheduler.forward(1L, TimeUnit.SECONDS);
        ((TimeoutHandler)Mockito.verify((Object)this.handlerA, (VerificationMode)Mockito.never())).onTimeout((Timer)ArgumentMatchers.any());
        ((TimeoutHandler)Mockito.verify((Object)this.handlerB, (VerificationMode)Mockito.never())).onTimeout((Timer)ArgumentMatchers.any());
    }

    @Test
    public void shouldInvokeMultipleHandlersOnSameTimeout() throws Exception {
        this.timerA.set(TimeoutFactory.fixedTimeout((long)1L, (TimeUnit)TimeUnit.SECONDS));
        this.timerB.set(TimeoutFactory.fixedTimeout((long)1L, (TimeUnit)TimeUnit.SECONDS));
        this.scheduler.forward(1L, TimeUnit.SECONDS);
        ((TimeoutHandler)Mockito.verify((Object)this.handlerA, (VerificationMode)Mockito.times((int)1))).onTimeout(this.timerA);
        ((TimeoutHandler)Mockito.verify((Object)this.handlerB, (VerificationMode)Mockito.times((int)1))).onTimeout(this.timerB);
    }

    @Test
    public void shouldInvokeTimersOnExplicitInvocation() throws Exception {
        this.timerService.invoke((TimerService.TimerName)Timers.TIMER_A);
        ((TimeoutHandler)Mockito.verify((Object)this.handlerA, (VerificationMode)Mockito.times((int)1))).onTimeout(this.timerA);
        ((TimeoutHandler)Mockito.verify((Object)this.handlerB, (VerificationMode)Mockito.never())).onTimeout((Timer)ArgumentMatchers.any());
        Mockito.reset((Object[])new TimeoutHandler[]{this.handlerA});
        Mockito.reset((Object[])new TimeoutHandler[]{this.handlerB});
        this.timerService.invoke((TimerService.TimerName)Timers.TIMER_B);
        ((TimeoutHandler)Mockito.verify((Object)this.handlerA, (VerificationMode)Mockito.never())).onTimeout((Timer)ArgumentMatchers.any());
        ((TimeoutHandler)Mockito.verify((Object)this.handlerB, (VerificationMode)Mockito.times((int)1))).onTimeout(this.timerB);
    }

    @Test
    public void shouldTimeoutAfterReset() throws Exception {
        this.timerA.set(TimeoutFactory.fixedTimeout((long)1L, (TimeUnit)TimeUnit.SECONDS));
        this.scheduler.forward(900L, TimeUnit.MILLISECONDS);
        this.timerA.reset();
        this.scheduler.forward(900L, TimeUnit.MILLISECONDS);
        ((TimeoutHandler)Mockito.verify((Object)this.handlerA, (VerificationMode)Mockito.never())).onTimeout((Timer)ArgumentMatchers.any());
        this.scheduler.forward(100L, TimeUnit.MILLISECONDS);
        ((TimeoutHandler)Mockito.verify((Object)this.handlerA, (VerificationMode)Mockito.times((int)1))).onTimeout((Timer)ArgumentMatchers.any());
    }

    @Test
    public void shouldTimeoutSingleTimeAfterMultipleResets() throws Exception {
        this.timerA.set(TimeoutFactory.fixedTimeout((long)1L, (TimeUnit)TimeUnit.SECONDS));
        this.scheduler.forward(900L, TimeUnit.MILLISECONDS);
        this.timerA.reset();
        this.scheduler.forward(900L, TimeUnit.MILLISECONDS);
        this.timerA.reset();
        this.scheduler.forward(900L, TimeUnit.MILLISECONDS);
        this.timerA.reset();
        this.scheduler.forward(1000L, TimeUnit.MILLISECONDS);
        ((TimeoutHandler)Mockito.verify((Object)this.handlerA, (VerificationMode)Mockito.times((int)1))).onTimeout((Timer)ArgumentMatchers.any());
        Mockito.reset((Object[])new TimeoutHandler[]{this.handlerA});
        this.scheduler.forward(5000L, TimeUnit.MILLISECONDS);
        ((TimeoutHandler)Mockito.verify((Object)this.handlerA, (VerificationMode)Mockito.never())).onTimeout((Timer)ArgumentMatchers.any());
    }

    @Test
    public void shouldNotInvokeCancelledTimer() throws Exception {
        this.timerA.set(TimeoutFactory.fixedTimeout((long)1L, (TimeUnit)TimeUnit.SECONDS));
        this.scheduler.forward(900L, TimeUnit.MILLISECONDS);
        this.timerA.cancel(Timer.CancelMode.SYNC_WAIT);
        this.scheduler.forward(100L, TimeUnit.MILLISECONDS);
        ((TimeoutHandler)Mockito.verify((Object)this.handlerA, (VerificationMode)Mockito.never())).onTimeout((Timer)ArgumentMatchers.any());
    }

    @Test
    public void shouldAwaitCancellationUnderRealScheduler() throws Throwable {
        CentralJobScheduler scheduler = new CentralJobScheduler();
        scheduler.init();
        scheduler.start();
        TimerService timerService = new TimerService((JobScheduler)scheduler, (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out));
        CountDownLatch started = new CountDownLatch(1);
        CountDownLatch finished = new CountDownLatch(1);
        TimeoutHandler handlerA = timer -> {
            started.countDown();
            finished.await();
        };
        TimeoutHandler handlerB = timer -> finished.countDown();
        Timer timerA = timerService.create((TimerService.TimerName)Timers.TIMER_A, this.group, handlerA);
        timerA.set(TimeoutFactory.fixedTimeout((long)0L, (TimeUnit)TimeUnit.SECONDS));
        started.await();
        Timer timerB = timerService.create((TimerService.TimerName)Timers.TIMER_B, this.group, handlerB);
        timerB.set(TimeoutFactory.fixedTimeout((long)2L, (TimeUnit)TimeUnit.SECONDS));
        timerA.cancel(Timer.CancelMode.SYNC_WAIT);
        Assert.assertEquals((long)0L, (long)finished.getCount());
        scheduler.stop();
        scheduler.shutdown();
    }

    @Test
    public void shouldBeAbleToCancelBeforeHandlingWithRealScheduler() throws Throwable {
        CentralJobScheduler scheduler = new CentralJobScheduler();
        scheduler.init();
        scheduler.start();
        TimerService timerService = new TimerService((JobScheduler)scheduler, (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out));
        TimeoutHandler handlerA = timer -> {};
        Timer timer2 = timerService.create((TimerService.TimerName)Timers.TIMER_A, this.group, handlerA);
        timer2.set(TimeoutFactory.fixedTimeout((long)2L, (TimeUnit)TimeUnit.SECONDS));
        timer2.cancel(Timer.CancelMode.SYNC_WAIT);
        scheduler.stop();
        scheduler.shutdown();
    }

    static enum Timers implements TimerService.TimerName
    {
        TIMER_A,
        TIMER_B;

    }
}

