/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.discovery.MockSrvRecordResolver;
import org.neo4j.causalclustering.discovery.SrvHostnameResolver;
import org.neo4j.causalclustering.discovery.SrvRecordResolver;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;

public class SrvHostnameResolverTest {
    MockSrvRecordResolver mockSrvRecordResolver = new MockSrvRecordResolver(new HashMap<String, List<SrvRecordResolver.SrvRecord>>(){
        {
            this.put("emptyrecord.com", new ArrayList());
        }
    });
    AssertableLogProvider logProvider = new AssertableLogProvider();
    AssertableLogProvider userLogProvider = new AssertableLogProvider();
    private SrvHostnameResolver resolver = new SrvHostnameResolver((LogProvider)this.logProvider, (LogProvider)this.userLogProvider, (SrvRecordResolver)this.mockSrvRecordResolver);

    @Test
    public void hostnamesAndPortsAreResolvedByTheResolver() {
        this.mockSrvRecordResolver.addRecords("_discovery._tcp.google.com", Arrays.asList(SrvRecordResolver.SrvRecord.parse((String)"1 1 80 1.2.3.4"), SrvRecordResolver.SrvRecord.parse((String)"1 1 8080 5.6.7.8")));
        Collection resolvedAddresses = this.resolver.resolve(new AdvertisedSocketAddress("_discovery._tcp.google.com", 0));
        Assert.assertEquals((long)2L, (long)resolvedAddresses.size());
        Assert.assertTrue((boolean)resolvedAddresses.removeIf(address -> address.getHostname().equals("1.2.3.4") && address.getPort() == 80));
        Assert.assertTrue((boolean)resolvedAddresses.removeIf(address -> address.getHostname().equals("5.6.7.8") && address.getPort() == 8080));
    }

    @Test
    public void resolutionDetailsAreLoggedToUserLogs() {
        this.mockSrvRecordResolver.addRecord("_resolutionDetailsAreLoggedToUserLogs._test.neo4j.com", SrvRecordResolver.SrvRecord.parse((String)"1 1 4321 1.2.3.4"));
        this.resolver.resolve(new AdvertisedSocketAddress("_resolutionDetailsAreLoggedToUserLogs._test.neo4j.com", 0));
        this.userLogProvider.assertContainsMessageContaining("Resolved initial host '%s' to %s");
    }

    @Test
    public void unknownHostExceptionsAreLoggedAsErrors() {
        this.resolver.resolve(new AdvertisedSocketAddress("unknown.com", 0));
        this.logProvider.assertContainsMessageContaining("Failed to resolve srv records for '%s'");
    }

    @Test
    public void emptyRecordListsAreLoggedAsErrors() {
        this.resolver.resolve(new AdvertisedSocketAddress("emptyrecord.com", 0));
        this.logProvider.assertContainsMessageContaining("Failed to resolve srv records for '%s'");
    }
}

