/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helpers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;

public class CausalClusteringTestHelpers {
    public static String transactionAddress(GraphDatabaseFacade graphDatabase) {
        AdvertisedSocketAddress hostnamePort = (AdvertisedSocketAddress)((Config)graphDatabase.getDependencyResolver().resolveDependency(Config.class)).get(CausalClusteringSettings.transaction_advertised_address);
        return String.format("%s:%s", hostnamePort.getHostname(), hostnamePort.getPort());
    }

    public static String backupAddress(GraphDatabaseFacade graphDatabaseFacade) {
        HostnamePort backupAddress = (HostnamePort)((Config)graphDatabaseFacade.getDependencyResolver().resolveDependency(Config.class)).get(OnlineBackupSettings.online_backup_server);
        return String.format("%s:%s", backupAddress.getHost(), backupAddress.getPort());
    }

    public static Map<Integer, String> distributeDatabaseNamesToHostNums(int nHosts, Set<String> databaseNames) {
        int nDatabases = databaseNames.size();
        int maxCapacity = nHosts % nDatabases == 0 ? nHosts / nDatabases : nHosts / nDatabases + 1;
        List repeated = databaseNames.stream().flatMap(db -> IntStream.range(0, maxCapacity).mapToObj(ignored -> db)).collect(Collectors.toList());
        HashMap<Integer, String> mapping = new HashMap<Integer, String>(nHosts);
        for (int hostId = 0; hostId < nHosts; ++hostId) {
            mapping.put(hostId, (String)repeated.get(hostId));
        }
        return mapping;
    }
}

