/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.messaging.marshalling.StringMarshal;

public class StringMarshalTest {
    @Test
    public void shouldSerializeAndDeserializeString() {
        String TEST_STRING = "ABC123_?";
        ByteBuf buffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        StringMarshal.marshal((ByteBuf)buffer, (String)"ABC123_?");
        String reconstructed = StringMarshal.unmarshal((ByteBuf)buffer);
        Assert.assertNotSame((Object)"ABC123_?", (Object)reconstructed);
        Assert.assertEquals((Object)"ABC123_?", (Object)reconstructed);
    }

    @Test
    public void shouldSerializeAndDeserializeEmptyString() {
        String TEST_STRING = "";
        ByteBuf buffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        StringMarshal.marshal((ByteBuf)buffer, (String)"");
        String reconstructed = StringMarshal.unmarshal((ByteBuf)buffer);
        Assert.assertNotSame((Object)"", (Object)reconstructed);
        Assert.assertEquals((Object)"", (Object)reconstructed);
    }

    @Test
    public void shouldSerializeAndDeserializeNull() {
        ByteBuf buffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        StringMarshal.marshal((ByteBuf)buffer, null);
        String reconstructed = StringMarshal.unmarshal((ByteBuf)buffer);
        Assert.assertNull((Object)reconstructed);
    }
}

