/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.ClientHandshakeException;
import org.neo4j.causalclustering.protocol.handshake.ClientMessage;
import org.neo4j.causalclustering.protocol.handshake.ClientMessageDecoder;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.ServerMessageEncoder;
import org.neo4j.causalclustering.protocol.handshake.StatusCode;
import org.neo4j.causalclustering.protocol.handshake.SwitchOverResponse;

@RunWith(value=Parameterized.class)
public class ClientMessageEncodingTest {
    private final ClientMessage message;
    private final ServerMessageEncoder encoder = new ServerMessageEncoder();
    private final ClientMessageDecoder decoder = new ClientMessageDecoder();

    private List<Object> encodeDecode(ClientMessage message) throws ClientHandshakeException {
        ByteBuf byteBuf = Unpooled.directBuffer();
        ArrayList<Object> output = new ArrayList<Object>();
        this.encoder.encode(null, message, byteBuf);
        this.decoder.decode(null, byteBuf, output);
        return output;
    }

    @Parameterized.Parameters(name="ResponseMessage-{0}")
    public static Collection<ClientMessage> data() {
        return Arrays.asList(new ApplicationProtocolResponse(StatusCode.FAILURE, "protocol", 13), new ModifierProtocolResponse(StatusCode.SUCCESS, "modifier", "7"), new SwitchOverResponse(StatusCode.FAILURE));
    }

    public ClientMessageEncodingTest(ClientMessage message) {
        this.message = message;
    }

    @Test
    public void shouldCompleteEncodingRoundTrip() throws ClientHandshakeException {
        List<Object> output = this.encodeDecode(this.message);
        Assert.assertThat(output, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)output.get(0), (Matcher)Matchers.equalTo((Object)this.message));
    }
}

