/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.RaftProtocolClientInstaller;
import org.neo4j.causalclustering.core.consensus.RaftProtocolServerInstaller;
import org.neo4j.causalclustering.handlers.VoidPipelineWrapperFactory;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.protocol.ModifierProtocolInstaller;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.ProtocolInstallerRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.HandshakeClientInitializer;
import org.neo4j.causalclustering.protocol.handshake.HandshakeServerInitializer;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.stream.Streams;
import org.neo4j.test.assertion.Assert;

@RunWith(value=Parameterized.class)
public class NettyInstalledProtocolsIT {
    private Parameters parameters;
    private static final int TIMEOUT_SECONDS = 10;
    private static final LogProvider logProvider = FormattedLogProvider.toOutputStream((OutputStream)System.out);
    private Server server;
    private Client client;

    public NettyInstalledProtocolsIT(Parameters parameters) {
        this.parameters = parameters;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Parameters> data() {
        Stream noModifierProtocols = Stream.of(Optional.empty());
        Stream<Optional> individualModifierProtocols = Stream.of(Protocol.ModifierProtocols.values()).map(Optional::of);
        return Stream.concat(noModifierProtocols, individualModifierProtocols).map(NettyInstalledProtocolsIT::raft1WithCompressionModifier).collect(Collectors.toList());
    }

    private static Parameters raft1WithCompressionModifier(Optional<Protocol.ModifierProtocol> protocol) {
        List versions = Streams.ofOptional(protocol).map(Protocol::implementation).collect(Collectors.toList());
        return new Parameters("Raft 1, modifiers: " + protocol, new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, Collections.singletonList(Protocol.ApplicationProtocols.RAFT_1.implementation())), Collections.singletonList(new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.COMPRESSION, versions)));
    }

    @Test
    public void shouldSuccessfullySendAndReceiveAMessage() throws Throwable {
        RaftMessages.Heartbeat raftMessage = new RaftMessages.Heartbeat(new MemberId(UUID.randomUUID()), 1L, 2L, 3L);
        RaftMessages.ClusterIdAwareMessage networkMessage = RaftMessages.ClusterIdAwareMessage.of((ClusterId)new ClusterId(UUID.randomUUID()), (RaftMessages.RaftMessage)raftMessage);
        this.client.send(networkMessage).syncUninterruptibly();
        Assert.assertEventually(messages -> String.format("Received messages %s should contain message decorating %s", messages, raftMessage), () -> this.server.received(), (Matcher)Matchers.contains(this.messageMatches((RaftMessages.ClusterIdAwareMessage<? extends RaftMessages.RaftMessage>)networkMessage)), (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Before
    public void setUp() {
        ApplicationProtocolRepository applicationProtocolRepository = new ApplicationProtocolRepository((Protocol.ApplicationProtocol[])Protocol.ApplicationProtocols.values(), this.parameters.applicationSupportedProtocol);
        ModifierProtocolRepository modifierProtocolRepository = new ModifierProtocolRepository((Protocol.ModifierProtocol[])Protocol.ModifierProtocols.values(), this.parameters.modifierSupportedProtocols);
        NettyPipelineBuilderFactory serverPipelineBuilderFactory = new NettyPipelineBuilderFactory(VoidPipelineWrapperFactory.VOID_WRAPPER);
        NettyPipelineBuilderFactory clientPipelineBuilderFactory = new NettyPipelineBuilderFactory(VoidPipelineWrapperFactory.VOID_WRAPPER);
        this.server = new Server(serverPipelineBuilderFactory);
        this.server.start(applicationProtocolRepository, modifierProtocolRepository);
        Config config = Config.builder().withSetting(CausalClusteringSettings.handshake_timeout, "10s").build();
        this.client = new Client(applicationProtocolRepository, modifierProtocolRepository, clientPipelineBuilderFactory, config);
        this.client.connect(this.server.port());
    }

    @After
    public void tearDown() {
        this.client.disconnect();
        this.server.stop();
    }

    private Matcher<Object> messageMatches(RaftMessages.ClusterIdAwareMessage<? extends RaftMessages.RaftMessage> expected) {
        return new MessageMatcher(expected);
    }

    class MessageMatcher
    extends BaseMatcher<Object> {
        private final RaftMessages.ClusterIdAwareMessage<? extends RaftMessages.RaftMessage> expected;

        MessageMatcher(RaftMessages.ClusterIdAwareMessage<? extends RaftMessages.RaftMessage> expected) {
            this.expected = expected;
        }

        public boolean matches(Object item) {
            if (item instanceof RaftMessages.ClusterIdAwareMessage) {
                RaftMessages.ClusterIdAwareMessage message = (RaftMessages.ClusterIdAwareMessage)item;
                return message.clusterId().equals((Object)this.expected.clusterId()) && message.message().equals(this.expected.message());
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("Cluster ID ").appendValue((Object)this.expected.clusterId()).appendText(" message ").appendValue((Object)this.expected.message());
        }
    }

    static class Client {
        private Bootstrap bootstrap;
        private NioEventLoopGroup eventLoopGroup;
        private Channel channel;
        private HandshakeClientInitializer handshakeClientInitializer;

        Client(ApplicationProtocolRepository applicationProtocolRepository, ModifierProtocolRepository modifierProtocolRepository, NettyPipelineBuilderFactory pipelineBuilderFactory, Config config) {
            RaftProtocolClientInstaller.Factory raftFactory = new RaftProtocolClientInstaller.Factory(pipelineBuilderFactory, logProvider);
            ProtocolInstallerRepository protocolInstallerRepository = new ProtocolInstallerRepository(Collections.singletonList(raftFactory), (Collection)ModifierProtocolInstaller.allClientInstallers);
            this.eventLoopGroup = new NioEventLoopGroup();
            Duration handshakeTimeout = (Duration)config.get(CausalClusteringSettings.handshake_timeout);
            this.handshakeClientInitializer = new HandshakeClientInitializer(applicationProtocolRepository, modifierProtocolRepository, protocolInstallerRepository, pipelineBuilderFactory, handshakeTimeout, logProvider);
            this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)this.handshakeClientInitializer);
        }

        void connect(int port) {
            ChannelFuture channelFuture = this.bootstrap.connect("localhost", port).syncUninterruptibly();
            this.channel = channelFuture.channel();
        }

        void disconnect() {
            if (this.channel != null) {
                this.channel.close().syncUninterruptibly();
                this.eventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS).syncUninterruptibly();
            }
        }

        ChannelFuture send(Object message) {
            return this.channel.writeAndFlush(message);
        }
    }

    static class Server {
        private Channel channel;
        private NioEventLoopGroup eventLoopGroup;
        private final List<Object> received = new CopyOnWriteArrayList<Object>();
        private NettyPipelineBuilderFactory pipelineBuilderFactory;
        ChannelInboundHandler nettyHandler = new SimpleChannelInboundHandler<Object>(){

            protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
                received.add(msg);
            }
        };

        Server(NettyPipelineBuilderFactory pipelineBuilderFactory) {
            this.pipelineBuilderFactory = pipelineBuilderFactory;
        }

        void start(ApplicationProtocolRepository applicationProtocolRepository, ModifierProtocolRepository modifierProtocolRepository) {
            RaftProtocolServerInstaller.Factory raftFactory = new RaftProtocolServerInstaller.Factory(this.nettyHandler, this.pipelineBuilderFactory, logProvider);
            ProtocolInstallerRepository protocolInstallerRepository = new ProtocolInstallerRepository(Collections.singletonList(raftFactory), (Collection)ModifierProtocolInstaller.allServerInstallers);
            this.eventLoopGroup = new NioEventLoopGroup();
            ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)this.eventLoopGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).localAddress(PortAuthority.allocatePort())).childHandler((ChannelHandler)new HandshakeServerInitializer(applicationProtocolRepository, modifierProtocolRepository, protocolInstallerRepository, this.pipelineBuilderFactory, logProvider).asChannelInitializer());
            this.channel = bootstrap.bind().syncUninterruptibly().channel();
        }

        void stop() {
            this.channel.close().syncUninterruptibly();
            this.eventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
        }

        int port() {
            return ((InetSocketAddress)this.channel.localAddress()).getPort();
        }

        public Collection<Object> received() {
            return this.received;
        }
    }

    private static class Parameters {
        final String name;
        final ApplicationSupportedProtocols applicationSupportedProtocol;
        final Collection<ModifierSupportedProtocols> modifierSupportedProtocols;

        Parameters(String name, ApplicationSupportedProtocols applicationSupportedProtocol, Collection<ModifierSupportedProtocols> modifierSupportedProtocols) {
            this.name = name;
            this.applicationSupportedProtocol = applicationSupportedProtocol;
            this.modifierSupportedProtocols = modifierSupportedProtocols;
        }

        public String toString() {
            return this.name;
        }
    }
}

