/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.load_balancing.plugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.routing.Endpoint;
import org.neo4j.causalclustering.routing.load_balancing.LoadBalancingPlugin;
import org.neo4j.causalclustering.routing.load_balancing.LoadBalancingProcessor;
import org.neo4j.causalclustering.routing.load_balancing.LoadBalancingResult;
import org.neo4j.causalclustering.routing.load_balancing.plugins.ServerShufflingProcessor;
import org.neo4j.helpers.AdvertisedSocketAddress;

public class ServerShufflingProcessorTest {
    @Test
    public void shouldShuffleServers() throws Exception {
        LoadBalancingProcessor delegate = (LoadBalancingProcessor)Mockito.mock(LoadBalancingPlugin.class);
        List<Endpoint> routers = Arrays.asList(Endpoint.route((AdvertisedSocketAddress)new AdvertisedSocketAddress("route", 1)), Endpoint.route((AdvertisedSocketAddress)new AdvertisedSocketAddress("route", 2)));
        List<Endpoint> writers = Arrays.asList(Endpoint.write((AdvertisedSocketAddress)new AdvertisedSocketAddress("write", 3)), Endpoint.write((AdvertisedSocketAddress)new AdvertisedSocketAddress("write", 4)), Endpoint.write((AdvertisedSocketAddress)new AdvertisedSocketAddress("write", 5)));
        List<Endpoint> readers = Arrays.asList(Endpoint.read((AdvertisedSocketAddress)new AdvertisedSocketAddress("read", 6)), Endpoint.read((AdvertisedSocketAddress)new AdvertisedSocketAddress("read", 7)), Endpoint.read((AdvertisedSocketAddress)new AdvertisedSocketAddress("read", 8)), Endpoint.read((AdvertisedSocketAddress)new AdvertisedSocketAddress("read", 9)));
        long ttl = 1000L;
        LoadBalancingResult result = new LoadBalancingResult(new ArrayList<Endpoint>(routers), new ArrayList<Endpoint>(writers), new ArrayList<Endpoint>(readers), ttl);
        Mockito.when((Object)delegate.run((Map)ArgumentMatchers.any())).thenReturn((Object)result);
        ServerShufflingProcessor plugin = new ServerShufflingProcessor(delegate);
        boolean completeShuffle = false;
        for (int i = 0; i < 1000; ++i) {
            LoadBalancingProcessor.Result shuffledResult = plugin.run(Collections.emptyMap());
            Assert.assertThat((Object)shuffledResult.routeEndpoints(), (Matcher)Matchers.containsInAnyOrder((Object[])routers.toArray()));
            Assert.assertThat((Object)shuffledResult.writeEndpoints(), (Matcher)Matchers.containsInAnyOrder((Object[])writers.toArray()));
            Assert.assertThat((Object)shuffledResult.readEndpoints(), (Matcher)Matchers.containsInAnyOrder((Object[])readers.toArray()));
            Assert.assertEquals((long)shuffledResult.ttlMillis(), (long)ttl);
            boolean readersEqual = shuffledResult.readEndpoints().equals(readers);
            boolean writersEqual = shuffledResult.writeEndpoints().equals(writers);
            boolean routersEqual = shuffledResult.routeEndpoints().equals(routers);
            if (readersEqual || writersEqual || routersEqual) continue;
            completeShuffle = true;
            break;
        }
        Assert.assertTrue((boolean)completeShuffle);
    }
}

