/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.routing.load_balancing.filters.Filter;
import org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies.FilterBuilder;
import org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies.FilterConfigParser;
import org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies.InvalidFilterSpecification;

public class FilterConfigParserTest {
    @Test
    public void shouldThrowExceptionOnInvalidConfig() {
        String[] invalidConfigs;
        for (String invalidConfig : invalidConfigs = new String[]{"", ";", "(", ")", "()", ",", "\"", "'", "groups", "min", "unknown", "unknown()", "unknown(something)", "min()", "min(2,5)", "groups()", "all(2)", "min(five)", "groups(group1_%)", "groups(group2_%)", "groups(group 2)", "%groups(group2)", "ta%gs(group2)", "ta-gs(group2)", "groups(group1),groups(group2)", "groups(group1);;groups(group2)", "groups(group1)+groups(group2)", "halt();groups(group)", "halt();halt()", "groups(group1);halt();groups(group2)", "groups(group1);groups(group2);halt();groups(group3)", "groups(group1) -> halt()", "halt() -> groups(group1)", "groups(group1) -> groups(group2) -> halt()", "groups(group1) -> halt() -> groups(group2)", "groups(group)->all()", "all()->all()", "groups(A)->all()->groups(B)"}) {
            try {
                Filter parsedFilter = FilterConfigParser.parse((String)invalidConfig);
                Assert.fail((String)String.format("Config should have been invalid: '%s' but generated: %s", invalidConfig, parsedFilter));
            }
            catch (InvalidFilterSpecification invalidFilterSpecification) {
                // empty catch block
            }
        }
    }

    @Test
    public void shouldParseValidConfigs() {
        Object[][] validConfigs;
        for (Object[] validConfig : validConfigs = new Object[][]{{"min(2);", FilterBuilder.filter().min(2).newRule().all().build()}, {"groups(5);", FilterBuilder.filter().groups("5").newRule().all().build()}, {"all()", FilterBuilder.filter().all().build()}, {"all() -> groups(5);", FilterBuilder.filter().groups("5").newRule().all().build()}, {"all() -> groups(5);all()", FilterBuilder.filter().groups("5").newRule().all().build()}, {"all() -> groups(A); all() -> groups(B); halt()", FilterBuilder.filter().groups("A").newRule().groups("B").build()}, {"groups(groupA);", FilterBuilder.filter().groups("groupA").newRule().all().build()}, {"groups(groupA,groupB); halt()", FilterBuilder.filter().groups("groupA", "groupB").build()}, {"groups ( groupA , groupB ); halt()", FilterBuilder.filter().groups("groupA", "groupB").build()}, {"groups(group1)->groups(group2); halt()", FilterBuilder.filter().groups("group1").groups("group2").build()}, {"groups(group1)->groups(group2); halt();", FilterBuilder.filter().groups("group1").groups("group2").build()}, {"groups(group-1)->groups(group-2); halt();", FilterBuilder.filter().groups("group-1").groups("group-2").build()}, {"groups(group1)->groups(group2)->min(4); groups(group3,group4)->min(2); halt();", FilterBuilder.filter().groups("group1").groups("group2").min(4).newRule().groups("group3", "group4").min(2).build()}, {"groups(group1,group2,group3,group4)->min(2); groups(group3,group4);", FilterBuilder.filter().groups("group1", "group2", "group3", "group4").min(2).newRule().groups("group3", "group4").newRule().all().build()}}) {
            String config = (String)validConfig[0];
            Filter expectedFilter = (Filter)validConfig[1];
            try {
                Filter parsedFilter = FilterConfigParser.parse((String)config);
                Assert.assertEquals((String)String.format("Config '%s' should generate expected filter", config), (Object)expectedFilter, (Object)parsedFilter);
            }
            catch (InvalidFilterSpecification e) {
                Assert.fail((String)String.format("Config should have been valid: '%s'", config));
            }
        }
    }
}

