/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies;

import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.routing.load_balancing.filters.Filter;
import org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies.AnyGroupFilter;
import org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies.FilteringPolicy;
import org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies.Policies;
import org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies.Policy;
import org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies.ServerInfo;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.Log;

public class PoliciesTest {
    private Log log = (Log)Mockito.mock(Log.class);

    @Test
    public void shouldSupplyDefaultUnfilteredPolicyForEmptyContext() throws Exception {
        Policies policies = new Policies(this.log);
        Policy policy = policies.selectFor(Collections.emptyMap());
        Set input = Iterators.asSet((Object[])new ServerInfo[]{new ServerInfo(new AdvertisedSocketAddress("bolt", 1), new MemberId(UUID.randomUUID()), Iterators.asSet((Object[])new String[]{"groupA"})), new ServerInfo(new AdvertisedSocketAddress("bolt", 2), new MemberId(UUID.randomUUID()), Iterators.asSet((Object[])new String[]{"groupB"}))});
        Set output = policy.apply(input);
        Assert.assertEquals((Object)input, (Object)output);
        Assert.assertEquals((Object)Policies.DEFAULT_POLICY, (Object)policy);
    }

    @Test
    public void shouldThrowExceptionOnUnknownPolicyName() {
        Policies policies = new Policies(this.log);
        try {
            policies.selectFor(MapUtil.stringMap((String[])new String[]{"policy", "unknown-policy"}));
            Assert.fail();
        }
        catch (ProcedureException e) {
            Assert.assertEquals((Object)Status.Procedure.ProcedureCallFailed, (Object)e.status());
        }
    }

    @Test
    public void shouldThrowExceptionOnSelectionOfUnregisteredDefault() {
        Policies policies = new Policies(this.log);
        try {
            policies.selectFor(MapUtil.stringMap((String[])new String[]{"policy", "default"}));
            Assert.fail();
        }
        catch (ProcedureException e) {
            Assert.assertEquals((Object)Status.Procedure.ProcedureCallFailed, (Object)e.status());
        }
    }

    @Test
    public void shouldAllowOverridingDefaultPolicy() throws Exception {
        Policies policies = new Policies(this.log);
        String defaulyPolicyName = "default";
        FilteringPolicy defaultPolicy = new FilteringPolicy((Filter)new AnyGroupFilter(new String[]{"groupA", "groupB"}));
        policies.addPolicy(defaulyPolicyName, (Policy)defaultPolicy);
        Policy selectedPolicy = policies.selectFor(Collections.emptyMap());
        Assert.assertEquals((Object)defaultPolicy, (Object)selectedPolicy);
        Assert.assertNotEquals((Object)Policies.DEFAULT_POLICY, (Object)selectedPolicy);
    }

    @Test
    public void shouldAllowLookupOfAddedPolicy() throws Exception {
        Policies policies = new Policies(this.log);
        String myPolicyName = "china";
        Policy myPolicy = data -> data;
        policies.addPolicy(myPolicyName, myPolicy);
        Policy selectedPolicy = policies.selectFor(MapUtil.stringMap((String[])new String[]{"policy", myPolicyName}));
        Assert.assertEquals((Object)myPolicy, (Object)selectedPolicy);
    }
}

