/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class SampleData {
    private static final Label LABEL = Label.label((String)"ExampleNode");
    private static final String PROPERTY_KEY = "prop";

    private SampleData() {
    }

    public static void createSomeData(int items, Cluster cluster) throws Exception {
        for (int i = 0; i < items; ++i) {
            cluster.coreTx((db, tx) -> {
                Node node = db.createNode(new Label[]{LABEL});
                node.setProperty("foobar", (Object)"baz_bat");
                tx.success();
            });
        }
    }

    public static void createData(GraphDatabaseService db, int size) {
        for (int i = 0; i < size; ++i) {
            Node node1 = db.createNode(new Label[]{LABEL});
            Node node2 = db.createNode(new Label[]{LABEL});
            node1.setProperty(PROPERTY_KEY, (Object)("svej" + i));
            node2.setProperty("tjabba", (Object)"tjena");
            node1.setProperty("foobar", (Object)"baz_bat");
            node2.setProperty("foobar", (Object)"baz_bat");
            Relationship rel = node1.createRelationshipTo(node2, RelationshipType.withName((String)"halla"));
            rel.setProperty("this", (Object)"that");
        }
    }

    public static void createSchema(GraphDatabaseService db) {
        db.schema().constraintFor(LABEL).assertPropertyIsUnique(PROPERTY_KEY).create();
    }
}

