/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchUpResponseHandler;
import org.neo4j.causalclustering.catchup.CatchupProtocolClientInstaller;
import org.neo4j.causalclustering.handlers.VoidPipelineWrapperFactory;
import org.neo4j.causalclustering.protocol.ModifierProtocolInstaller;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.ProtocolInstaller;
import org.neo4j.causalclustering.protocol.ProtocolInstallerRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.HandshakeClientInitializer;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;

public class CatchupClientBuilder {
    private Duration handshakeTimeout = Duration.ofSeconds(5L);
    private LogProvider logProvider = NullLogProvider.getInstance();
    private NettyPipelineBuilderFactory pipelineBuilder = new NettyPipelineBuilderFactory(VoidPipelineWrapperFactory.VOID_WRAPPER);
    private ApplicationSupportedProtocols catchupProtocols = new ApplicationSupportedProtocols(Protocol.ApplicationProtocolCategory.CATCHUP, Collections.emptyList());
    private Collection<ModifierSupportedProtocols> modifierProtocols = Collections.emptyList();
    private long inactivityTimeoutMillis = TimeUnit.SECONDS.toMillis(20L);
    private Clock clock = Clocks.systemClock();

    public CatchupClientBuilder() {
    }

    public CatchupClientBuilder(ApplicationSupportedProtocols catchupProtocols, Collection<ModifierSupportedProtocols> modifierProtocols, NettyPipelineBuilderFactory pipelineBuilder, Duration handshakeTimeout, long inactivityTimeoutMillis, LogProvider logProvider, Clock clock) {
        this.catchupProtocols = catchupProtocols;
        this.modifierProtocols = modifierProtocols;
        this.pipelineBuilder = pipelineBuilder;
        this.handshakeTimeout = handshakeTimeout;
        this.logProvider = logProvider;
        this.inactivityTimeoutMillis = inactivityTimeoutMillis;
        this.clock = clock;
    }

    public CatchupClientBuilder catchupProtocols(ApplicationSupportedProtocols catchupProtocols) {
        this.catchupProtocols = catchupProtocols;
        return this;
    }

    public CatchupClientBuilder modifierProtocols(Collection<ModifierSupportedProtocols> modifierProtocols) {
        this.modifierProtocols = modifierProtocols;
        return this;
    }

    public CatchupClientBuilder pipelineBuilder(NettyPipelineBuilderFactory pipelineBuilder) {
        this.pipelineBuilder = pipelineBuilder;
        return this;
    }

    public CatchupClientBuilder handshakeTimeout(Duration handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
        return this;
    }

    public CatchupClientBuilder inactivityTimeoutMillis(long inactivityTimeoutMillis) {
        this.inactivityTimeoutMillis = inactivityTimeoutMillis;
        return this;
    }

    public CatchupClientBuilder logProvider(LogProvider logProvider) {
        this.logProvider = logProvider;
        return this;
    }

    public CatchupClientBuilder clock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public CatchUpClient build() {
        ApplicationProtocolRepository applicationProtocolRepository = new ApplicationProtocolRepository(Protocol.ApplicationProtocols.values(), this.catchupProtocols);
        ModifierProtocolRepository modifierProtocolRepository = new ModifierProtocolRepository(Protocol.ModifierProtocols.values(), this.modifierProtocols);
        Function<CatchUpResponseHandler, ChannelInitializer<SocketChannel>> channelInitializer = handler -> {
            List installers = Collections.singletonList(new CatchupProtocolClientInstaller.Factory(this.pipelineBuilder, this.logProvider, (CatchUpResponseHandler)handler));
            ProtocolInstallerRepository<ProtocolInstaller.Orientation.Client> protocolInstallerRepository = new ProtocolInstallerRepository<ProtocolInstaller.Orientation.Client>(installers, ModifierProtocolInstaller.allClientInstallers);
            return new HandshakeClientInitializer(applicationProtocolRepository, modifierProtocolRepository, protocolInstallerRepository, this.pipelineBuilder, this.handshakeTimeout, this.logProvider);
        };
        return new CatchUpClient(this.logProvider, this.clock, this.inactivityTimeoutMillis, channelInitializer);
    }
}

