/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.schedule.TimeoutFactory;
import org.neo4j.causalclustering.core.consensus.schedule.TimeoutHandler;
import org.neo4j.causalclustering.core.consensus.schedule.Timer;
import org.neo4j.causalclustering.core.consensus.schedule.TimerService;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;

class LeaderAvailabilityTimers {
    private final long electionTimeout;
    private final long heartbeatInterval;
    private final Clock clock;
    private final TimerService timerService;
    private final Log log;
    private volatile long lastElectionRenewalMillis;
    private Timer heartbeatTimer;
    private Timer electionTimer;

    LeaderAvailabilityTimers(Duration electionTimeout, Duration heartbeatInterval, Clock clock, TimerService timerService, LogProvider logProvider) {
        this.electionTimeout = electionTimeout.toMillis();
        this.heartbeatInterval = heartbeatInterval.toMillis();
        this.clock = clock;
        this.timerService = timerService;
        this.log = logProvider.getLog(this.getClass());
        if (this.electionTimeout < this.heartbeatInterval) {
            throw new IllegalArgumentException(String.format("Election timeout %s should not be shorter than heartbeat interval %s", this.electionTimeout, this.heartbeatInterval));
        }
    }

    synchronized void start(ThrowingConsumer<Clock, Exception> electionAction, ThrowingConsumer<Clock, Exception> heartbeatAction) {
        this.electionTimer = this.timerService.create(RaftMachine.Timeouts.ELECTION, JobScheduler.Groups.raft, this.renewing(electionAction));
        this.electionTimer.set(TimeoutFactory.uniformRandomTimeout(this.electionTimeout, this.electionTimeout * 2L, TimeUnit.MILLISECONDS));
        this.heartbeatTimer = this.timerService.create(RaftMachine.Timeouts.HEARTBEAT, JobScheduler.Groups.raft, this.renewing(heartbeatAction));
        this.heartbeatTimer.set(TimeoutFactory.fixedTimeout(this.heartbeatInterval, TimeUnit.MILLISECONDS));
        this.lastElectionRenewalMillis = this.clock.millis();
    }

    synchronized void stop() {
        if (this.electionTimer != null) {
            this.electionTimer.cancel(Timer.CancelMode.ASYNC);
        }
        if (this.heartbeatTimer != null) {
            this.heartbeatTimer.cancel(Timer.CancelMode.ASYNC);
        }
    }

    synchronized void renewElection() {
        this.lastElectionRenewalMillis = this.clock.millis();
        if (this.electionTimer != null) {
            this.electionTimer.reset();
        }
    }

    synchronized boolean isElectionTimedOut() {
        return this.clock.millis() - this.lastElectionRenewalMillis >= this.electionTimeout;
    }

    long getElectionTimeout() {
        return this.electionTimeout;
    }

    private TimeoutHandler renewing(ThrowingConsumer<Clock, Exception> action) {
        return timeout -> {
            try {
                action.accept((Object)this.clock);
            }
            catch (Exception e) {
                this.log.error("Failed to process timeout.", (Throwable)e);
            }
            timeout.reset();
        };
    }
}

