/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.snapshot;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchUpClientException;
import org.neo4j.causalclustering.catchup.CatchUpResponseAdaptor;
import org.neo4j.causalclustering.catchup.CatchupAddressProvider;
import org.neo4j.causalclustering.catchup.CatchupAddressResolutionException;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.storecopy.CommitStateHelper;
import org.neo4j.causalclustering.catchup.storecopy.DatabaseShutdownException;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.RemoteStore;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyProcess;
import org.neo4j.causalclustering.catchup.storecopy.StoreIdDownloadFailedException;
import org.neo4j.causalclustering.core.state.CoreSnapshotService;
import org.neo4j.causalclustering.core.state.machines.CoreStateMachines;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshotRequest;
import org.neo4j.causalclustering.helper.Suspendable;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class CoreStateDownloader {
    private final LocalDatabase localDatabase;
    private final Suspendable suspendOnStoreCopy;
    private final RemoteStore remoteStore;
    private final CatchUpClient catchUpClient;
    private final Log log;
    private final StoreCopyProcess storeCopyProcess;
    private final CoreStateMachines coreStateMachines;
    private final CoreSnapshotService snapshotService;
    private CommitStateHelper commitStateHelper;

    public CoreStateDownloader(LocalDatabase localDatabase, Suspendable suspendOnStoreCopy, RemoteStore remoteStore, CatchUpClient catchUpClient, LogProvider logProvider, StoreCopyProcess storeCopyProcess, CoreStateMachines coreStateMachines, CoreSnapshotService snapshotService, CommitStateHelper commitStateHelper) {
        this.localDatabase = localDatabase;
        this.suspendOnStoreCopy = suspendOnStoreCopy;
        this.remoteStore = remoteStore;
        this.catchUpClient = catchUpClient;
        this.log = logProvider.getLog(this.getClass());
        this.storeCopyProcess = storeCopyProcess;
        this.coreStateMachines = coreStateMachines;
        this.snapshotService = snapshotService;
        this.commitStateHelper = commitStateHelper;
    }

    boolean downloadSnapshot(CatchupAddressProvider addressProvider) throws LifecycleException, IOException, DatabaseShutdownException {
        CoreSnapshot coreSnapshot;
        StoreId remoteStoreId;
        AdvertisedSocketAddress primary;
        boolean isEmptyStore = this.localDatabase.isEmpty();
        if (this.commitStateHelper.hasTxLogs(this.localDatabase.storeDir())) {
            this.log.info("Recovering local database");
            CoreStateDownloader.ensure(this.localDatabase::start, "start local database");
            CoreStateDownloader.ensure(this.localDatabase::stop, "stop local database");
        }
        try {
            primary = addressProvider.primary();
            remoteStoreId = this.remoteStore.getStoreId(primary);
        }
        catch (CatchupAddressResolutionException | StoreIdDownloadFailedException e) {
            this.log.warn("Store copy failed", (Throwable)e);
            return false;
        }
        if (!isEmptyStore && !remoteStoreId.equals(this.localDatabase.storeId())) {
            this.log.error("Store copy failed due to store ID mismatch");
            return false;
        }
        CoreStateDownloader.ensure(this.suspendOnStoreCopy::disable, "disable auxiliary services before store copy");
        CoreStateDownloader.ensure(this.localDatabase::stopForStoreCopy, "stop local database for store copy");
        this.log.info("Downloading snapshot from core server at %s", new Object[]{primary});
        try {
            coreSnapshot = this.catchUpClient.makeBlockingRequest(primary, new CoreSnapshotRequest(), new CatchUpResponseAdaptor<CoreSnapshot>(){

                @Override
                public void onCoreSnapshot(CompletableFuture<CoreSnapshot> signal, CoreSnapshot response) {
                    signal.complete(response);
                }
            });
        }
        catch (CatchUpClientException e) {
            this.log.warn("Store copy failed", (Throwable)e);
            return false;
        }
        if (!isEmptyStore) {
            CatchupResult catchupResult;
            StoreId localStoreId = this.localDatabase.storeId();
            try {
                catchupResult = this.remoteStore.tryCatchingUp(primary, localStoreId, this.localDatabase.storeDir(), false);
            }
            catch (StoreCopyFailedException e) {
                this.log.warn("Failed to catch up", (Throwable)e);
                return false;
            }
            if (catchupResult == CatchupResult.E_TRANSACTION_PRUNED) {
                this.log.warn(String.format("Failed to pull transactions from (%s). They may have been pruned away", primary));
                this.localDatabase.delete();
                isEmptyStore = true;
            } else if (catchupResult != CatchupResult.SUCCESS_END_OF_STREAM) {
                this.log.warn(String.format("Unexpected catchup operation result %s from %s", new Object[]{catchupResult, primary}));
                return false;
            }
        }
        if (isEmptyStore) {
            try {
                this.storeCopyProcess.replaceWithStoreFrom(addressProvider, remoteStoreId);
            }
            catch (StoreCopyFailedException e) {
                this.log.warn("Failed to copy and replace store", (Throwable)e);
                return false;
            }
        }
        this.snapshotService.installSnapshot(coreSnapshot);
        this.log.info("Core snapshot installed: " + coreSnapshot);
        this.log.info("Starting local database");
        CoreStateDownloader.ensure(this.localDatabase::start, "start local database after store copy");
        this.coreStateMachines.installCommitProcess(this.localDatabase.getCommitProcess());
        CoreStateDownloader.ensure(this.suspendOnStoreCopy::enable, "enable auxiliary services after store copy");
        return true;
    }

    private static void ensure(LifecycleAction action, String operation) {
        try {
            action.perform();
        }
        catch (Throwable cause) {
            throw new LifecycleException("Failed to " + operation, cause);
        }
    }

    public static interface LifecycleAction {
        public void perform() throws Throwable;
    }
}

