/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.diagnostics;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.neo4j.causalclustering.core.consensus.log.segmented.FileNames;
import org.neo4j.causalclustering.core.state.ClusterStateDirectory;
import org.neo4j.causalclustering.core.state.ClusterStateException;
import org.neo4j.diagnostics.DiagnosticsOfflineReportProvider;
import org.neo4j.diagnostics.DiagnosticsReportSource;
import org.neo4j.diagnostics.DiagnosticsReportSources;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class ClusterDiagnosticsOfflineReportProvider
extends DiagnosticsOfflineReportProvider {
    private FileSystemAbstraction fs;
    private File clusterStateDirectory;
    private ClusterStateException clusterStateException;

    public ClusterDiagnosticsOfflineReportProvider() {
        super("cc", "raft", new String[]{"ccstate"});
    }

    public void init(FileSystemAbstraction fs, Config config, File storeDirectory) {
        this.fs = fs;
        File dataDir = (File)config.get(GraphDatabaseSettings.data_directory);
        try {
            this.clusterStateDirectory = new ClusterStateDirectory(dataDir, storeDirectory, true).initialize(fs).get();
        }
        catch (ClusterStateException e) {
            this.clusterStateException = e;
        }
    }

    protected List<DiagnosticsReportSource> provideSources(Set<String> classifiers) {
        ArrayList<DiagnosticsReportSource> sources = new ArrayList<DiagnosticsReportSource>();
        if (classifiers.contains("raft")) {
            this.getRaftLogs(sources);
        }
        if (classifiers.contains("ccstate")) {
            this.getClusterState(sources);
        }
        return sources;
    }

    private void getRaftLogs(List<DiagnosticsReportSource> sources) {
        if (this.clusterStateDirectory == null) {
            sources.add(DiagnosticsReportSources.newDiagnosticsString((String)"raft.txt", () -> "error creating ClusterStateDirectory: " + this.clusterStateException.getMessage()));
            return;
        }
        File raftLogDirectory = new File(this.clusterStateDirectory, "raft-log");
        FileNames fileNames = new FileNames(raftLogDirectory);
        SortedMap<Long, File> allFiles = fileNames.getAllFiles(this.fs, (Log)NullLog.getInstance());
        for (File logFile : allFiles.values()) {
            sources.add(DiagnosticsReportSources.newDiagnosticsFile((String)("raft/" + logFile.getName()), (FileSystemAbstraction)this.fs, (File)logFile));
        }
    }

    private void getClusterState(List<DiagnosticsReportSource> sources) {
        if (this.clusterStateDirectory == null) {
            sources.add(DiagnosticsReportSources.newDiagnosticsString((String)"ccstate.txt", () -> "error creating ClusterStateDirectory: " + this.clusterStateException.getMessage()));
            return;
        }
        for (File file : this.fs.listFiles(this.clusterStateDirectory, (dir, name) -> !name.equals("raft-log"))) {
            this.addDirectory("ccstate", file, sources);
        }
    }

    private void addDirectory(String path, File dir, List<DiagnosticsReportSource> sources) {
        String currentLevel = path + File.separator + dir.getName();
        if (this.fs.isDirectory(dir)) {
            File[] files = this.fs.listFiles(dir);
            if (files != null) {
                for (File file : files) {
                    this.addDirectory(currentLevel, file, sources);
                }
            }
        } else {
            sources.add(DiagnosticsReportSources.newDiagnosticsFile((String)currentLevel, (FileSystemAbstraction)this.fs, (File)dir));
        }
    }
}

