/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.DiscoveryServerInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.SocketAddressParser;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;

public final class HazelcastClusterTopology {
    private static final String DISCOVERY_SERVER = "discovery_server";
    static final String MEMBER_UUID = "member_uuid";
    static final String TRANSACTION_SERVER = "transaction_server";
    static final String RAFT_SERVER = "raft_server";
    static final String CLIENT_CONNECTOR_ADDRESSES = "client_connector_addresses";
    static final String MEMBER_DB_NAME = "member_database_name";
    private static final String REFUSE_TO_BE_LEADER_KEY = "refuseToBeLeader";
    static final String CLUSTER_UUID_DB_NAME_MAP = "cluster_uuid";
    static final String SERVER_GROUPS_MULTIMAP = "groups";
    static final String READ_REPLICA_TRANSACTION_SERVER_ADDRESS_MAP = "read-replica-transaction-servers";
    static final String READ_REPLICA_BOLT_ADDRESS_MAP = "read_replicas";
    static final String READ_REPLICA_MEMBER_ID_MAP = "read-replica-member-ids";
    static final String READ_REPLICAS_DB_NAME_MAP = "read_replicas_database_names";
    static final String DB_NAME_LEADER_TERM_PREFIX = "leader_term_for_database_name_";

    private HazelcastClusterTopology() {
    }

    static ReadReplicaTopology getReadReplicaTopology(HazelcastInstance hazelcastInstance, Log log) {
        Map<MemberId, ReadReplicaInfo> readReplicas = Collections.emptyMap();
        if (hazelcastInstance != null) {
            readReplicas = HazelcastClusterTopology.readReplicas(hazelcastInstance);
        } else {
            log.info("Cannot currently bind to distributed discovery service.");
        }
        return new ReadReplicaTopology(readReplicas);
    }

    static CoreTopology getCoreTopology(HazelcastInstance hazelcastInstance, Config config, Log log) {
        Map<MemberId, CoreServerInfo> coreMembers = Collections.emptyMap();
        boolean canBeBootstrapped = false;
        ClusterId clusterId = null;
        String dbName = (String)config.get(CausalClusteringSettings.database);
        if (hazelcastInstance != null) {
            Set hzMembers = hazelcastInstance.getCluster().getMembers();
            canBeBootstrapped = HazelcastClusterTopology.canBeBootstrapped(hazelcastInstance, config);
            coreMembers = HazelcastClusterTopology.toCoreMemberMap(hzMembers, log, hazelcastInstance);
            clusterId = HazelcastClusterTopology.getClusterId(hazelcastInstance, dbName);
        } else {
            log.info("Cannot currently bind to distributed discovery service.");
        }
        return new CoreTopology(clusterId, canBeBootstrapped, coreMembers);
    }

    public static Map<MemberId, AdvertisedSocketAddress> extractCatchupAddressesMap(CoreTopology coreTopology, ReadReplicaTopology rrTopology) {
        HashMap<MemberId, AdvertisedSocketAddress> catchupAddressMap = new HashMap<MemberId, AdvertisedSocketAddress>();
        for (Map.Entry<MemberId, CoreServerInfo> entry : coreTopology.members().entrySet()) {
            catchupAddressMap.put(entry.getKey(), entry.getValue().getCatchupServer());
        }
        for (Map.Entry<MemberId, DiscoveryServerInfo> entry : rrTopology.members().entrySet()) {
            catchupAddressMap.put(entry.getKey(), ((ReadReplicaInfo)entry.getValue()).getCatchupServer());
        }
        return catchupAddressMap;
    }

    private static ClusterId getClusterId(HazelcastInstance hazelcastInstance, String dbName) {
        IMap uuidPerDbCluster = hazelcastInstance.getMap(CLUSTER_UUID_DB_NAME_MAP);
        UUID uuid = (UUID)uuidPerDbCluster.get((Object)dbName);
        return uuid != null ? new ClusterId(uuid) : null;
    }

    private static Set<String> getDBNames(HazelcastInstance hazelcastInstance) {
        IMap uuidPerDbCluster = hazelcastInstance.getMap(CLUSTER_UUID_DB_NAME_MAP);
        return uuidPerDbCluster.keySet();
    }

    public static Map<MemberId, RoleInfo> getCoreRoles(HazelcastInstance hazelcastInstance, Set<MemberId> coreMembers) {
        Set<String> dbNames = HazelcastClusterTopology.getDBNames(hazelcastInstance);
        Set allLeaders = dbNames.stream().map(n -> HazelcastClusterTopology.getLeaderForDBName(hazelcastInstance, n)).filter(Optional::isPresent).map(l -> ((LeaderInfo)l.get()).memberId()).collect(Collectors.toSet());
        Function<MemberId, RoleInfo> roleMapper = m -> allLeaders.contains(m) ? RoleInfo.LEADER : RoleInfo.FOLLOWER;
        return coreMembers.stream().collect(Collectors.toMap(Function.identity(), roleMapper));
    }

    static boolean casClusterId(HazelcastInstance hazelcastInstance, ClusterId clusterId, String dbName) {
        IMap uuidPerDbCluster = hazelcastInstance.getMap(CLUSTER_UUID_DB_NAME_MAP);
        UUID uuid = (UUID)uuidPerDbCluster.putIfAbsent((Object)dbName, (Object)clusterId.uuid());
        return uuid == null || clusterId.uuid().equals(uuid);
    }

    private static Map<MemberId, ReadReplicaInfo> readReplicas(HazelcastInstance hazelcastInstance) {
        HashMap<MemberId, ReadReplicaInfo> result = new HashMap<MemberId, ReadReplicaInfo>();
        IMap clientAddressMap = hazelcastInstance.getMap(READ_REPLICA_BOLT_ADDRESS_MAP);
        IMap txServerMap = hazelcastInstance.getMap(READ_REPLICA_TRANSACTION_SERVER_ADDRESS_MAP);
        IMap memberIdMap = hazelcastInstance.getMap(READ_REPLICA_MEMBER_ID_MAP);
        MultiMap serverGroups = hazelcastInstance.getMultiMap(SERVER_GROUPS_MULTIMAP);
        IMap memberDbMap = hazelcastInstance.getMap(READ_REPLICAS_DB_NAME_MAP);
        if (Stream.of(clientAddressMap, txServerMap, memberIdMap, serverGroups).anyMatch(Objects::isNull)) {
            return result;
        }
        for (String hzUUID : clientAddressMap.keySet()) {
            String sAddresses = (String)clientAddressMap.get((Object)hzUUID);
            String sCatchupAddress = (String)txServerMap.get((Object)hzUUID);
            String sMemberId = (String)memberIdMap.get((Object)hzUUID);
            String dbName = (String)memberDbMap.get((Object)hzUUID);
            Collection sServerGroups = serverGroups.get((Object)hzUUID);
            if (Stream.concat(Stream.of(sServerGroups), Stream.of(sAddresses, sCatchupAddress, sMemberId)).anyMatch(Objects::isNull)) continue;
            ClientConnectorAddresses clientConnectorAddresses = ClientConnectorAddresses.fromString(sAddresses);
            AdvertisedSocketAddress catchupAddress = (AdvertisedSocketAddress)SocketAddressParser.socketAddress((String)sCatchupAddress, AdvertisedSocketAddress::new);
            ReadReplicaInfo readReplicaInfo = new ReadReplicaInfo(clientConnectorAddresses, catchupAddress, Iterables.asSet((Iterable)sServerGroups), dbName);
            result.put(new MemberId(UUID.fromString(sMemberId)), readReplicaInfo);
        }
        return result;
    }

    static void casLeaders(HazelcastInstance hazelcastInstance, LeaderInfo leaderInfo, String dbName) {
        boolean sameTermButNoStepdown;
        IAtomicReference leaderRef = hazelcastInstance.getAtomicReference(DB_NAME_LEADER_TERM_PREFIX + dbName);
        LeaderInfo current = (LeaderInfo)leaderRef.get();
        Optional<LeaderInfo> currentOpt = Optional.ofNullable(current);
        boolean sameLeader = currentOpt.map(LeaderInfo::memberId).equals(Optional.ofNullable(leaderInfo.memberId()));
        int termComparison = currentOpt.map(l -> Long.compare(l.term(), leaderInfo.term())).orElse(-1);
        boolean greaterTermExists = termComparison > 0;
        boolean bl = sameTermButNoStepdown = termComparison == 0 && !leaderInfo.isSteppingDown();
        if (sameLeader || greaterTermExists || sameTermButNoStepdown) {
            return;
        }
        leaderRef.compareAndSet((Object)current, (Object)leaderInfo);
    }

    private static Optional<LeaderInfo> getLeaderForDBName(HazelcastInstance hazelcastInstance, String dbName) {
        IAtomicReference leader = hazelcastInstance.getAtomicReference(DB_NAME_LEADER_TERM_PREFIX + dbName);
        return Optional.ofNullable(leader.get());
    }

    private static boolean canBeBootstrapped(HazelcastInstance hazelcastInstance, Config config) {
        Set members = hazelcastInstance.getCluster().getMembers();
        String dbName = (String)config.get(CausalClusteringSettings.database);
        Predicate<Member> acceptsToBeLeader = m -> m.getBooleanAttribute(REFUSE_TO_BE_LEADER_KEY) == false;
        Predicate<Member> hostsMyDb = m -> dbName.equals(m.getStringAttribute(MEMBER_DB_NAME));
        Stream<Member> membersWhoCanLeadForMyDb = members.stream().filter(acceptsToBeLeader).filter(hostsMyDb);
        Optional<Member> firstAppropriateMember = membersWhoCanLeadForMyDb.findFirst();
        return firstAppropriateMember.map(Member::localMember).orElse(false);
    }

    static Map<MemberId, CoreServerInfo> toCoreMemberMap(Set<Member> members, Log log, HazelcastInstance hazelcastInstance) {
        HashMap<MemberId, CoreServerInfo> coreMembers = new HashMap<MemberId, CoreServerInfo>();
        MultiMap serverGroupsMMap = hazelcastInstance.getMultiMap(SERVER_GROUPS_MULTIMAP);
        for (Member member : members) {
            List<String> attrKeys = Arrays.asList(MEMBER_UUID, RAFT_SERVER, TRANSACTION_SERVER, CLIENT_CONNECTOR_ADDRESSES, MEMBER_DB_NAME);
            HashMap<String, String> attrMap = new HashMap<String, String>();
            boolean incomplete = false;
            for (String attrKey : attrKeys) {
                String attrValue = member.getStringAttribute(attrKey);
                if (attrValue == null) {
                    log.warn("Missing member attribute '%s' for member %s", new Object[]{attrKey, member});
                    incomplete = true;
                    continue;
                }
                attrMap.put(attrKey, attrValue);
            }
            if (incomplete) continue;
            CoreServerInfo coreServerInfo = new CoreServerInfo((AdvertisedSocketAddress)SocketAddressParser.socketAddress((String)((String)attrMap.get(RAFT_SERVER)), AdvertisedSocketAddress::new), (AdvertisedSocketAddress)SocketAddressParser.socketAddress((String)((String)attrMap.get(TRANSACTION_SERVER)), AdvertisedSocketAddress::new), ClientConnectorAddresses.fromString((String)attrMap.get(CLIENT_CONNECTOR_ADDRESSES)), Iterables.asSet((Iterable)serverGroupsMMap.get(attrMap.get(MEMBER_UUID))), (String)attrMap.get(MEMBER_DB_NAME));
            MemberId memberId = new MemberId(UUID.fromString((String)attrMap.get(MEMBER_UUID)));
            coreMembers.put(memberId, coreServerInfo);
        }
        return coreMembers;
    }

    static void refreshGroups(HazelcastInstance hazelcastInstance, String memberId, List<String> groups) {
        MultiMap groupsMap = hazelcastInstance.getMultiMap(SERVER_GROUPS_MULTIMAP);
        Collection existing = groupsMap.get((Object)memberId);
        Set<String> superfluous = existing.stream().filter(t -> !groups.contains(t)).collect(Collectors.toSet());
        Set<String> missing = groups.stream().filter(t -> !existing.contains(t)).collect(Collectors.toSet());
        missing.forEach(group -> groupsMap.put((Object)memberId, group));
        superfluous.forEach(group -> groupsMap.remove((Object)memberId, group));
    }

    static MemberAttributeConfig buildMemberAttributesForCore(MemberId myself, Config config) {
        MemberAttributeConfig memberAttributeConfig = new MemberAttributeConfig();
        memberAttributeConfig.setStringAttribute(MEMBER_UUID, myself.getUuid().toString());
        AdvertisedSocketAddress discoveryAddress = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.discovery_advertised_address);
        memberAttributeConfig.setStringAttribute(DISCOVERY_SERVER, discoveryAddress.toString());
        AdvertisedSocketAddress transactionSource = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.transaction_advertised_address);
        memberAttributeConfig.setStringAttribute(TRANSACTION_SERVER, transactionSource.toString());
        AdvertisedSocketAddress raftAddress = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.raft_advertised_address);
        memberAttributeConfig.setStringAttribute(RAFT_SERVER, raftAddress.toString());
        ClientConnectorAddresses clientConnectorAddresses = ClientConnectorAddresses.extractFromConfig(config);
        memberAttributeConfig.setStringAttribute(CLIENT_CONNECTOR_ADDRESSES, clientConnectorAddresses.toString());
        memberAttributeConfig.setBooleanAttribute(REFUSE_TO_BE_LEADER_KEY, ((Boolean)config.get(CausalClusteringSettings.refuse_to_be_leader)).booleanValue());
        memberAttributeConfig.setStringAttribute(MEMBER_DB_NAME, (String)config.get(CausalClusteringSettings.database));
        return memberAttributeConfig;
    }
}

