/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.identity;

import java.time.Clock;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.state.CoreBootstrapper;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;
import org.neo4j.causalclustering.core.state.storage.SimpleStorage;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.identity.BindingException;
import org.neo4j.causalclustering.identity.BoundState;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.DatabaseName;
import org.neo4j.function.ThrowingAction;
import org.neo4j.kernel.impl.util.CappedLogger;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ClusterBinder
implements Supplier<Optional<ClusterId>> {
    private final SimpleStorage<ClusterId> clusterIdStorage;
    private final SimpleStorage<DatabaseName> dbNameStorage;
    private final CoreTopologyService topologyService;
    private final CoreBootstrapper coreBootstrapper;
    private final Log log;
    private final CappedLogger cappedLog;
    private final Clock clock;
    private final ThrowingAction<InterruptedException> retryWaiter;
    private final long timeoutMillis;
    private final String dbName;
    private final int minCoreHosts;
    private ClusterId clusterId;

    public ClusterBinder(SimpleStorage<ClusterId> clusterIdStorage, SimpleStorage<DatabaseName> dbNameStorage, CoreTopologyService topologyService, Clock clock, ThrowingAction<InterruptedException> retryWaiter, long timeoutMillis, CoreBootstrapper coreBootstrapper, String dbName, int minCoreHosts, LogProvider logProvider) {
        this.clusterIdStorage = clusterIdStorage;
        this.dbNameStorage = dbNameStorage;
        this.topologyService = topologyService;
        this.coreBootstrapper = coreBootstrapper;
        this.log = logProvider.getLog(this.getClass());
        this.cappedLog = new CappedLogger(this.log).setTimeLimit(5L, TimeUnit.SECONDS, clock);
        this.clock = clock;
        this.retryWaiter = retryWaiter;
        this.timeoutMillis = timeoutMillis;
        this.dbName = dbName;
        this.minCoreHosts = minCoreHosts;
    }

    private boolean hostShouldBootstrapCluster(CoreTopology coreTopology) {
        int memberCount = coreTopology.members().size();
        if (memberCount < this.minCoreHosts) {
            String message = "Waiting for %d members. Currently discovered %d members: %s. ";
            this.cappedLog.info(String.format(message, this.minCoreHosts, memberCount, coreTopology.members()));
            return false;
        }
        if (!coreTopology.canBeBootstrapped()) {
            String message = "Discovered sufficient members (%d) but waiting for bootstrap by other instance.";
            this.cappedLog.info(String.format(message, memberCount));
            return false;
        }
        return true;
    }

    public BoundState bindToCluster() throws Throwable {
        CoreTopology topology;
        DatabaseName newName = new DatabaseName(this.dbName);
        this.dbNameStorage.writeOrVerify(newName, existing -> {
            if (!newName.equals(existing)) {
                throw new IllegalStateException(String.format("Your configured database name has changed. Found %s but expected %s in %s.", this.dbName, existing.name(), CausalClusteringSettings.database.name()));
            }
        });
        if (this.clusterIdStorage.exists()) {
            this.clusterId = this.clusterIdStorage.readState();
            this.publishClusterId(this.clusterId);
            this.log.info("Already bound to cluster: " + this.clusterId);
            return new BoundState(this.clusterId);
        }
        CoreSnapshot snapshot = null;
        long endTime = this.clock.millis() + this.timeoutMillis;
        do {
            if ((topology = this.topologyService.localCoreServers()).clusterId() != null) {
                this.clusterId = topology.clusterId();
                this.log.info("Bound to cluster: " + this.clusterId);
                continue;
            }
            if (this.hostShouldBootstrapCluster(topology)) {
                this.clusterId = new ClusterId(UUID.randomUUID());
                snapshot = this.coreBootstrapper.bootstrap(topology.members().keySet());
                this.log.info(String.format("Bootstrapped with snapshot: %s and clusterId: %s", snapshot, this.clusterId));
                this.publishClusterId(this.clusterId);
                continue;
            }
            this.retryWaiter.apply();
        } while (this.clusterId == null && this.clock.millis() < endTime);
        if (this.clusterId == null) {
            throw new TimeoutException(String.format("Failed to join a cluster with members %s. Another member should have published a clusterId but none was detected. Please restart the cluster.", topology));
        }
        this.clusterIdStorage.writeState(this.clusterId);
        return new BoundState(this.clusterId, snapshot);
    }

    @Override
    public Optional<ClusterId> get() {
        return Optional.ofNullable(this.clusterId);
    }

    private void publishClusterId(ClusterId localClusterId) throws BindingException, InterruptedException {
        boolean success = this.topologyService.setClusterId(localClusterId, this.dbName);
        if (!success) {
            throw new BindingException("Failed to publish: " + localClusterId);
        }
        this.log.info("Published: " + localClusterId);
    }
}

