/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.identity;

import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class ClusterId {
    private final UUID uuid;

    public ClusterId(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterId clusterId = (ClusterId)o;
        return Objects.equals(this.uuid, clusterId.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public UUID uuid() {
        return this.uuid;
    }

    public String toString() {
        return "ClusterId{uuid=" + this.uuid + '}';
    }

    public static class Marshal
    extends SafeChannelMarshal<ClusterId> {
        public static final Marshal INSTANCE = new Marshal();

        @Override
        public void marshal(ClusterId clusterId, WritableChannel channel) throws IOException {
            channel.putLong(clusterId.uuid.getMostSignificantBits());
            channel.putLong(clusterId.uuid.getLeastSignificantBits());
        }

        @Override
        public ClusterId unmarshal0(ReadableChannel channel) throws IOException {
            long mostSigBits = channel.getLong();
            long leastSigBits = channel.getLong();
            return new ClusterId(new UUID(mostSigBits, leastSigBits));
        }
    }
}

