/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.neo4j.causalclustering.protocol.Protocol;

public class ProtocolStack {
    private final Protocol.ApplicationProtocol applicationProtocol;
    private final List<Protocol.ModifierProtocol> modifierProtocols;

    public ProtocolStack(Protocol.ApplicationProtocol applicationProtocol, List<Protocol.ModifierProtocol> modifierProtocols) {
        this.applicationProtocol = applicationProtocol;
        this.modifierProtocols = Collections.unmodifiableList(modifierProtocols);
    }

    public Protocol.ApplicationProtocol applicationProtocol() {
        return this.applicationProtocol;
    }

    public List<Protocol.ModifierProtocol> modifierProtocols() {
        return this.modifierProtocols;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtocolStack that = (ProtocolStack)o;
        return Objects.equals(this.applicationProtocol, that.applicationProtocol) && Objects.equals(this.modifierProtocols, that.modifierProtocols);
    }

    public int hashCode() {
        return Objects.hash(this.applicationProtocol, this.modifierProtocols);
    }

    public String toString() {
        return "ProtocolStack{applicationProtocol=" + this.applicationProtocol + ", modifierProtocols=" + this.modifierProtocols + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Protocol.ApplicationProtocol applicationProtocol;
        private final List<Protocol.ModifierProtocol> modifierProtocols = new ArrayList<Protocol.ModifierProtocol>();

        private Builder() {
        }

        public Builder modifier(Protocol.ModifierProtocol modifierProtocol) {
            this.modifierProtocols.add(modifierProtocol);
            return this;
        }

        public Builder application(Protocol.ApplicationProtocol applicationProtocol) {
            this.applicationProtocol = applicationProtocol;
            return this;
        }

        ProtocolStack build() {
            return new ProtocolStack(this.applicationProtocol, this.modifierProtocols);
        }

        public String toString() {
            return "Builder{applicationProtocol=" + this.applicationProtocol + ", modifierProtocols=" + this.modifierProtocols + '}';
        }
    }
}

