/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.protocol.Protocol;

public abstract class SupportedProtocols<U extends Comparable<U>, T extends Protocol<U>> {
    private final Protocol.Category<T> category;
    private final List<U> versions;

    SupportedProtocols(Protocol.Category<T> category, List<U> versions) {
        this.category = category;
        this.versions = Collections.unmodifiableList(versions);
    }

    public Set<U> mutuallySupportedVersionsFor(Set<U> requestedVersions) {
        if (this.versions().isEmpty()) {
            return requestedVersions;
        }
        return requestedVersions.stream().filter(this.versions()::contains).collect(Collectors.toSet());
    }

    public Protocol.Category<T> identifier() {
        return this.category;
    }

    public List<U> versions() {
        return this.versions;
    }
}

