/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.logging;

import org.jboss.netty.logging.AbstractInternalLogger;
import org.jboss.netty.logging.InternalLogLevel;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class NettyLoggerFactory
extends InternalLoggerFactory {
    private LogProvider logProvider;

    public NettyLoggerFactory(LogProvider logProvider) {
        this.logProvider = logProvider;
    }

    public InternalLogger newInstance(String name) {
        final Log log = this.logProvider.getLog(name);
        return new AbstractInternalLogger(){

            public boolean isDebugEnabled() {
                return log.isDebugEnabled();
            }

            public boolean isInfoEnabled() {
                return true;
            }

            public boolean isWarnEnabled() {
                return true;
            }

            public boolean isErrorEnabled() {
                return true;
            }

            public boolean isEnabled(InternalLogLevel level) {
                return level != InternalLogLevel.DEBUG || this.isDebugEnabled();
            }

            public void debug(String msg) {
                log.debug(msg);
            }

            public void debug(String msg, Throwable cause) {
                log.debug(msg, cause);
            }

            public void info(String msg) {
                log.info(msg);
            }

            public void info(String msg, Throwable cause) {
                log.info(msg, cause);
            }

            public void warn(String msg) {
                log.warn(msg);
            }

            public void warn(String msg, Throwable cause) {
                log.warn(msg, cause);
            }

            public void error(String msg) {
                log.error(msg);
            }

            public void error(String msg, Throwable cause) {
                log.error(msg, cause);
            }
        };
    }
}

