/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageHolder;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastSerializer;
import org.neo4j.cluster.protocol.atomicbroadcast.Payload;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AtomicBroadcastMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.InstanceId;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.LearnerContext;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.LearnerMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.PaxosInstance;
import org.neo4j.cluster.statemachine.State;
import org.neo4j.logging.Log;

public enum LearnerState implements State<LearnerContext, LearnerMessage>
{
    start{

        public LearnerState handle(LearnerContext context, Message<LearnerMessage> message, MessageHolder outgoing) {
            if (message.getMessageType() == LearnerMessage.join) {
                return learner;
            }
            return this;
        }
    }
    ,
    learner{

        public LearnerState handle(LearnerContext context, Message<LearnerMessage> message, MessageHolder outgoing) throws IOException, ClassNotFoundException, URISyntaxException {
            switch (message.getMessageType()) {
                case learn: {
                    LearnerMessage.LearnState learnState = (LearnerMessage.LearnState)message.getPayload();
                    InstanceId instanceId = new InstanceId(message);
                    PaxosInstance instance = context.getPaxosInstance(instanceId);
                    Log log = context.getLog(this.getClass());
                    if (instanceId.getId() <= context.getLastDeliveredInstanceId()) break;
                    context.learnedInstanceId(instanceId.getId());
                    instance.closed(learnState.getValue(), message.getHeader("conversation-id"));
                    if (log.isDebugEnabled()) {
                        String description;
                        if (instance.value_2 instanceof Payload) {
                            AtomicBroadcastSerializer atomicBroadcastSerializer = context.newSerializer();
                            description = atomicBroadcastSerializer.receive((Payload)instance.value_2).toString();
                        } else {
                            description = instance.value_2.toString();
                        }
                        log.debug("Learned and closed instance " + instance.id + " from conversation " + instance.conversationIdHeader + " and the content was " + description);
                    }
                    if (instanceId.getId() == context.getLastDeliveredInstanceId() + 1L) {
                        instance.delivered();
                        outgoing.offer(Message.internal(AtomicBroadcastMessage.broadcastResponse, learnState.getValue()).setHeader("instance", instance.id.toString()).setHeader("conversation-id", instance.conversationIdHeader));
                        context.setLastDeliveredInstanceId(instanceId.getId());
                        long checkInstanceId = instanceId.getId() + 1L;
                        while ((instance = context.getPaxosInstance(new InstanceId(checkInstanceId))).isState(PaxosInstance.State.closed)) {
                            instance.delivered();
                            context.setLastDeliveredInstanceId(checkInstanceId);
                            Message<AtomicBroadcastMessage> learnMessage = Message.internal(AtomicBroadcastMessage.broadcastResponse, instance.value_2).setHeader("instance", instance.id.toString()).setHeader("conversation-id", instance.conversationIdHeader);
                            outgoing.offer(learnMessage);
                            ++checkInstanceId;
                        }
                        if (checkInstanceId == context.getLastKnownLearnedInstanceInCluster() + 1L) {
                            context.cancelTimeout("learn");
                            break;
                        }
                        context.getLog(LearnerState.class).debug("*** HOLE! WAITING FOR " + (context.getLastDeliveredInstanceId() + 1L));
                        break;
                    }
                    context.getLog(LearnerState.class).debug("*** GOT " + instanceId + ", WAITING FOR " + (context.getLastDeliveredInstanceId() + 1L));
                    context.setTimeout("learn", Message.timeout(LearnerMessage.learnTimedout, message));
                    break;
                }
                case learnTimedout: {
                    if (context.hasDeliveredAllKnownInstances()) break;
                    for (long instanceId = context.getLastDeliveredInstanceId() + 1L; instanceId < context.getLastKnownLearnedInstanceInCluster(); ++instanceId) {
                        InstanceId id = new InstanceId(instanceId);
                        PaxosInstance instance = context.getPaxosInstance(id);
                        if (instance.isState(PaxosInstance.State.closed) || instance.isState(PaxosInstance.State.delivered)) continue;
                        for (org.neo4j.cluster.InstanceId node : context.getAlive()) {
                            URI nodeUri = context.getUriForId(node);
                            if (node.equals(context.getMyId())) continue;
                            outgoing.offer(Message.to(LearnerMessage.learnRequest, nodeUri, new LearnerMessage.LearnRequestState()).setHeader("instance", id.toString()));
                        }
                    }
                    context.setTimeout("learn", Message.timeout(LearnerMessage.learnTimedout, message));
                    break;
                }
                case learnRequest: {
                    InstanceId instanceId = new InstanceId(message);
                    PaxosInstance instance = context.getPaxosInstance(instanceId);
                    if (instance.isState(PaxosInstance.State.closed) || instance.isState(PaxosInstance.State.delivered)) {
                        outgoing.offer(Message.respond(LearnerMessage.learn, message, new LearnerMessage.LearnState(instance.value_2)).setHeader("instance", instanceId.toString()).setHeader("conversation-id", instance.conversationIdHeader));
                        break;
                    }
                    outgoing.offer(message.copyHeadersTo(Message.respond(LearnerMessage.learnFailed, message, new LearnerMessage.LearnFailedState()), "instance"));
                    break;
                }
                case learnFailed: {
                    InstanceId instanceId = new InstanceId(message);
                    context.notifyLearnMiss(instanceId);
                    break;
                }
                case catchUp: {
                    long catchUpTo = (Long)message.getPayload();
                    if (context.getLastKnownLearnedInstanceInCluster() >= catchUpTo) break;
                    context.setNextInstanceId(catchUpTo + 1L);
                    for (long instanceId = context.getLastLearnedInstanceId() + 1L; instanceId <= catchUpTo; ++instanceId) {
                        InstanceId id = new InstanceId(instanceId);
                        PaxosInstance instance = context.getPaxosInstance(id);
                        if (instance.isState(PaxosInstance.State.closed) || instance.isState(PaxosInstance.State.delivered)) continue;
                        outgoing.offer(Message.to(LearnerMessage.learnRequest, this.lastKnownAliveUriOrSenderUri(context, message), new LearnerMessage.LearnRequestState()).setHeader("instance", id.toString()));
                        context.setTimeout("learn", Message.timeout(LearnerMessage.learnTimedout, message));
                        break;
                    }
                    org.neo4j.cluster.InstanceId instanceId = message.hasHeader("instance-id") ? new org.neo4j.cluster.InstanceId(Integer.parseInt(message.getHeader("instance-id"))) : context.getMyId();
                    context.setLastKnownLearnedInstanceInCluster(catchUpTo, instanceId);
                    break;
                }
                case leave: {
                    context.leave();
                    return start;
                }
            }
            return this;
        }

        private URI lastKnownAliveUriOrSenderUri(LearnerContext context, Message<LearnerMessage> message) throws URISyntaxException {
            org.neo4j.cluster.InstanceId lastKnownAliveInstance = context.getLastKnownAliveUpToDateInstance();
            if (lastKnownAliveInstance != null) {
                return context.getUriForId(lastKnownAliveInstance);
            }
            return new URI(message.getHeader("from"));
        }
    };

}

