/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.heartbeat;

import java.net.URI;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageHolder;
import org.neo4j.cluster.com.message.MessageProcessor;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.protocol.cluster.ClusterContext;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatMessage;

public class HeartbeatIAmAliveProcessor
implements MessageProcessor {
    private final MessageHolder output;
    private final ClusterContext clusterContext;

    public HeartbeatIAmAliveProcessor(MessageHolder output, ClusterContext clusterContext) {
        this.output = output;
        this.clusterContext = clusterContext;
    }

    @Override
    public boolean process(Message<? extends MessageType> message) {
        InstanceId theId;
        String from;
        if (!(message.isInternal() || message.getMessageType().equals(HeartbeatMessage.i_am_alive) || message.getMessageType().equals(HeartbeatMessage.suspicions) || (from = message.getHeader("from")).equals(message.getHeader("to")) || (theId = message.hasHeader("instance-id") ? new InstanceId(Integer.parseInt(message.getHeader("instance-id"))) : this.clusterContext.getConfiguration().getIdForUri(URI.create(from))) == null || !this.clusterContext.getConfiguration().getMembers().containsKey(theId) || this.clusterContext.isMe(theId))) {
            Message<HeartbeatMessage> heartbeatMessage = message.copyHeadersTo(Message.internal(HeartbeatMessage.i_am_alive, new HeartbeatMessage.IAmAliveState(theId)), "from", "instance-id");
            this.output.offer(heartbeatMessage);
        }
        return true;
    }
}

