/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.snapshot;

import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageHolder;
import org.neo4j.cluster.protocol.snapshot.SnapshotContext;
import org.neo4j.cluster.protocol.snapshot.SnapshotMessage;
import org.neo4j.cluster.protocol.snapshot.SnapshotProvider;
import org.neo4j.cluster.statemachine.State;

public enum SnapshotState implements State<SnapshotContext, SnapshotMessage>
{
    start{

        public SnapshotState handle(SnapshotContext context, Message<SnapshotMessage> message, MessageHolder outgoing) {
            switch (message.getMessageType()) {
                case setSnapshotProvider: {
                    SnapshotProvider snapshotProvider = (SnapshotProvider)message.getPayload();
                    context.setSnapshotProvider(snapshotProvider);
                    break;
                }
                case refreshSnapshot: {
                    if (context.getClusterContext().getConfiguration().getMembers().size() <= 1 || context.getSnapshotProvider() == null) {
                        return start;
                    }
                    InstanceId coordinator = context.getClusterContext().getConfiguration().getElected("coordinator");
                    if (coordinator != null) {
                        outgoing.offer(Message.to(SnapshotMessage.sendSnapshot, context.getClusterContext().getConfiguration().getUriForId(coordinator)));
                        return refreshing;
                    }
                    return start;
                }
                case join: {
                    return ready;
                }
            }
            return this;
        }
    }
    ,
    refreshing{

        public SnapshotState handle(SnapshotContext context, Message<SnapshotMessage> message, MessageHolder outgoing) {
            if (message.getMessageType() == SnapshotMessage.snapshot) {
                SnapshotMessage.SnapshotState state = (SnapshotMessage.SnapshotState)message.getPayload();
                state.setState(context.getSnapshotProvider(), context.getClusterContext().getObjectInputStreamFactory());
                return ready;
            }
            return this;
        }
    }
    ,
    ready{

        public SnapshotState handle(SnapshotContext context, Message<SnapshotMessage> message, MessageHolder outgoing) {
            switch (message.getMessageType()) {
                case refreshSnapshot: {
                    if (context.getClusterContext().getConfiguration().getMembers().size() <= 1 || context.getSnapshotProvider() == null) {
                        return ready;
                    }
                    InstanceId coordinator = context.getClusterContext().getConfiguration().getElected("coordinator");
                    if (coordinator != null && !coordinator.equals(context.getClusterContext().getMyId())) {
                        outgoing.offer(Message.to(SnapshotMessage.sendSnapshot, context.getClusterContext().getConfiguration().getUriForId(coordinator)));
                        return refreshing;
                    }
                    return ready;
                }
                case sendSnapshot: {
                    outgoing.offer(Message.respond(SnapshotMessage.snapshot, message, new SnapshotMessage.SnapshotState(context.getLearnerContext().getLastDeliveredInstanceId(), context.getSnapshotProvider(), context.getClusterContext().getObjectOutputStreamFactory())));
                    break;
                }
                case leave: {
                    return start;
                }
            }
            return this;
        }
    };

}

