/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.statemachine;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageHolder;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.statemachine.State;
import org.neo4j.cluster.statemachine.StateTransition;
import org.neo4j.cluster.statemachine.StateTransitionListener;
import org.neo4j.logging.LogProvider;

public class StateMachine<CONTEXT, MESSAGETYPE extends MessageType> {
    private CONTEXT context;
    private Class<MESSAGETYPE> messageEnumType;
    private State<CONTEXT, MESSAGETYPE> state;
    private LogProvider logProvider;
    private List<StateTransitionListener> listeners = new ArrayList<StateTransitionListener>();

    public StateMachine(CONTEXT context, Class<MESSAGETYPE> messageEnumType, State<CONTEXT, MESSAGETYPE> state, LogProvider logProvider) {
        this.context = context;
        this.messageEnumType = messageEnumType;
        this.state = state;
        this.logProvider = logProvider;
    }

    public Class<MESSAGETYPE> getMessageType() {
        return this.messageEnumType;
    }

    public State<CONTEXT, MESSAGETYPE> getState() {
        return this.state;
    }

    public Object getContext() {
        return this.context;
    }

    public void addStateTransitionListener(StateTransitionListener listener) {
        ArrayList<StateTransitionListener> newlisteners = new ArrayList<StateTransitionListener>(this.listeners);
        newlisteners.add(listener);
        this.listeners = newlisteners;
    }

    public void removeStateTransitionListener(StateTransitionListener listener) {
        ArrayList<StateTransitionListener> newListeners = new ArrayList<StateTransitionListener>(this.listeners);
        newListeners.remove(listener);
        this.listeners = newListeners;
    }

    public synchronized void handle(Message<MESSAGETYPE> message, MessageHolder outgoing) {
        try {
            State<CONTEXT, MESSAGETYPE> oldState = this.state;
            State<CONTEXT, MESSAGETYPE> newState = oldState.handle(this.context, message, outgoing);
            this.state = newState;
            StateTransition transition = new StateTransition(oldState, message, newState);
            for (StateTransitionListener listener : this.listeners) {
                try {
                    listener.stateTransition(transition);
                }
                catch (Throwable e) {
                    this.logProvider.getLog(listener.getClass()).warn("Listener threw exception", e);
                }
            }
        }
        catch (Throwable throwable) {
            this.logProvider.getLog(this.getClass()).warn("Exception in message handling", throwable);
        }
    }

    public String toString() {
        return this.state.toString() + ": " + this.context.toString();
    }
}

