/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.com.ClientCrashingWriter;
import org.neo4j.com.ComException;
import org.neo4j.com.ComExceptionHandler;
import org.neo4j.com.DataProducer;
import org.neo4j.com.FailingByteChannel;
import org.neo4j.com.FailingException;
import org.neo4j.com.IllegalProtocolVersionException;
import org.neo4j.com.KnownDataByteChannel;
import org.neo4j.com.MadeUpClient;
import org.neo4j.com.MadeUpCommunicationInterface;
import org.neo4j.com.MadeUpException;
import org.neo4j.com.MadeUpServer;
import org.neo4j.com.MadeUpServerImplementation;
import org.neo4j.com.MadeUpServerProcess;
import org.neo4j.com.MadeUpWriter;
import org.neo4j.com.ProtocolVersion;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.ServerInterface;
import org.neo4j.com.StartupData;
import org.neo4j.com.StoreIdTestFactory;
import org.neo4j.com.ToAssertionWriter;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TransactionStreamResponse;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.ports.allocation.PortAuthority;

public class CommunicationIT {
    private static final byte INTERNAL_PROTOCOL_VERSION = 0;
    private static final byte APPLICATION_PROTOCOL_VERSION = 0;
    private final LifeSupport life = new LifeSupport();
    private StoreId storeIdToUse;
    private Builder builder;

    @Before
    public void doBefore() {
        this.storeIdToUse = StoreIdTestFactory.newStoreIdForCurrentVersion();
        this.builder = new Builder();
    }

    @After
    public void shutdownLife() {
        this.life.shutdown();
    }

    @Test
    public void clientGetResponseFromServerViaComLayer() throws Throwable {
        MadeUpServerImplementation serverImplementation = new MadeUpServerImplementation(this.storeIdToUse);
        MadeUpServer server = this.builder.server(serverImplementation);
        MadeUpClient client = this.builder.client();
        this.addToLifeAndStart(server, client);
        int value1 = 10;
        int value2 = 5;
        Response<Integer> response = client.multiply(10, 5);
        this.waitUntilResponseHasBeenWritten(server, 1000);
        Assert.assertEquals((Object)(value1 * value2), (Object)response.response());
        Assert.assertTrue((boolean)serverImplementation.gotCalled());
        Assert.assertTrue((boolean)server.responseHasBeenWritten());
    }

    private void waitUntilResponseHasBeenWritten(MadeUpServer server, int maxTime) throws Exception {
        long time = System.currentTimeMillis();
        while (!server.responseHasBeenWritten() && System.currentTimeMillis() - time < (long)maxTime) {
            Thread.sleep(50L);
        }
    }

    @Test(expected=MismatchingStoreIdException.class)
    public void makeSureClientStoreIdsMustMatch() {
        MadeUpServer server = this.builder.server();
        MadeUpClient client = this.builder.storeId(StoreIdTestFactory.newStoreIdForCurrentVersion(10L, 10L, 10L, 10L)).client();
        this.addToLifeAndStart(server, client);
        client.multiply(1, 2);
    }

    @Test(expected=MismatchingStoreIdException.class)
    public void makeSureServerStoreIdsMustMatch() {
        MadeUpServer server = this.builder.storeId(StoreIdTestFactory.newStoreIdForCurrentVersion(10L, 10L, 10L, 10L)).server();
        MadeUpClient client = this.builder.client();
        this.addToLifeAndStart(server, client);
        client.multiply(1, 2);
    }

    @Test
    public void makeSureClientCanStreamBigData() {
        MadeUpServer server = this.builder.server();
        MadeUpClient client = this.builder.client();
        this.addToLifeAndStart(server, client);
        client.fetchDataStream(new ToAssertionWriter(), 0x300000);
    }

    @Test
    public void clientThrowsServerSideErrorMidwayThroughStreaming() {
        String failureMessage = "Just failing";
        MadeUpServerImplementation serverImplementation = new MadeUpServerImplementation(this.storeIdToUse){

            @Override
            public Response<Void> fetchDataStream(MadeUpWriter writer, int dataSize) {
                writer.write(new FailingByteChannel(dataSize, "Just failing"));
                return new TransactionStreamResponse(null, CommunicationIT.this.storeIdToUse, TransactionStream.EMPTY, ResourceReleaser.NO_OP);
            }
        };
        MadeUpServer server = this.builder.server(serverImplementation);
        MadeUpClient client = this.builder.client();
        this.addToLifeAndStart(server, client);
        try {
            client.fetchDataStream(new ToAssertionWriter(), 0x200000);
            Assert.fail((String)("Should have thrown " + MadeUpException.class.getSimpleName()));
        }
        catch (MadeUpException e) {
            Assert.assertEquals((Object)"Just failing", (Object)e.getMessage());
        }
    }

    @Test
    public void communicateBetweenJvms() {
        ServerInterface server = this.builder.serverInOtherJvm();
        server.awaitStarted();
        MadeUpClient client = this.builder.port(8888).client();
        this.life.add((Lifecycle)client);
        this.life.start();
        Assert.assertEquals((Object)45, (Object)client.multiply(9, 5).response());
        client.fetchDataStream(new ToAssertionWriter(), 0x300000);
        server.shutdown();
    }

    @Test
    public void throwingServerSideExceptionBackToClient() {
        MadeUpServer server = this.builder.server();
        MadeUpClient client = this.builder.client();
        this.addToLifeAndStart(server, client);
        String exceptionMessage = "The message";
        try {
            client.throwException(exceptionMessage);
            Assert.fail((String)("Should have thrown " + MadeUpException.class.getSimpleName()));
        }
        catch (MadeUpException e) {
            Assert.assertEquals((Object)exceptionMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void applicationProtocolVersionsMustMatch() {
        MadeUpServer server = this.builder.applicationProtocolVersion((byte)1).server();
        MadeUpClient client = this.builder.client();
        this.addToLifeAndStart(server, client);
        try {
            client.multiply(10, 20);
            Assert.fail((String)"Shouldn't be able to communicate with different application protocol versions");
        }
        catch (IllegalProtocolVersionException illegalProtocolVersionException) {
            // empty catch block
        }
    }

    @Test
    public void applicationProtocolVersionsMustMatchMultiJvm() {
        ServerInterface server = this.builder.applicationProtocolVersion((byte)1).serverInOtherJvm();
        server.awaitStarted();
        MadeUpClient client = this.builder.port(8888).client();
        this.life.add((Lifecycle)client);
        this.life.start();
        try {
            client.multiply(10, 20);
            Assert.fail((String)"Shouldn't be able to communicate with different application protocol versions");
        }
        catch (IllegalProtocolVersionException illegalProtocolVersionException) {
            // empty catch block
        }
        server.shutdown();
    }

    @Test
    public void internalProtocolVersionsMustMatch() {
        MadeUpServer server = this.builder.internalProtocolVersion((byte)1).server();
        MadeUpClient client = this.builder.internalProtocolVersion((byte)2).client();
        this.addToLifeAndStart(server, client);
        try {
            client.multiply(10, 20);
            Assert.fail((String)"Shouldn't be able to communicate with different application protocol versions");
        }
        catch (IllegalProtocolVersionException illegalProtocolVersionException) {
            // empty catch block
        }
    }

    @Test
    public void internalProtocolVersionsMustMatchMultiJvm() {
        ServerInterface server = this.builder.internalProtocolVersion((byte)1).serverInOtherJvm();
        server.awaitStarted();
        MadeUpClient client = this.builder.port(8888).internalProtocolVersion((byte)2).client();
        this.life.add((Lifecycle)client);
        this.life.start();
        try {
            client.multiply(10, 20);
            Assert.fail((String)"Shouldn't be able to communicate with different application protocol versions");
        }
        catch (IllegalProtocolVersionException illegalProtocolVersionException) {
            // empty catch block
        }
        server.shutdown();
    }

    @Test
    public void serverStopsStreamingToDeadClient() throws Throwable {
        MadeUpServer server = this.builder.server();
        MadeUpClient client = this.builder.client();
        this.addToLifeAndStart(server, client);
        int failAtSize = 1024;
        ClientCrashingWriter writer = new ClientCrashingWriter(client, failAtSize);
        try {
            client.fetchDataStream(writer, 0x6400000);
            Assert.assertTrue((writer.getSizeRead() >= failAtSize ? 1 : 0) != 0);
            Assert.fail((String)"Should fail in the middle");
        }
        catch (ComException comException) {
            // empty catch block
        }
        Assert.assertTrue((writer.getSizeRead() >= failAtSize ? 1 : 0) != 0);
        long maxWaitUntil = System.currentTimeMillis() + 60000L;
        while (!server.responseFailureEncountered() && System.currentTimeMillis() < maxWaitUntil) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)"Failure writing the response should have been encountered", (boolean)server.responseFailureEncountered());
        Assert.assertFalse((String)"Response shouldn't have been successful", (boolean)server.responseHasBeenWritten());
    }

    @Test
    public void serverContextVerificationCanThrowException() {
        String failureMessage = "I'm failing";
        TxChecksumVerifier failingVerifier = (txId, checksum) -> {
            throw new FailingException("I'm failing");
        };
        MadeUpServer server = this.builder.verifier(failingVerifier).server();
        MadeUpClient client = this.builder.client();
        this.addToLifeAndStart(server, client);
        try {
            client.multiply(10, 5);
            Assert.fail((String)"Should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void clientCanReadChunkSizeBiggerThanItsOwn() {
        int serverChunkSize = 20000;
        int clientChunkSize = serverChunkSize / 10;
        MadeUpServer server = this.builder.chunkSize(serverChunkSize).server();
        MadeUpClient client = this.builder.chunkSize(clientChunkSize).client();
        this.addToLifeAndStart(server, client);
        client.fetchDataStream(new ToAssertionWriter(), serverChunkSize * 2);
    }

    @Test
    public void serverCanReadChunkSizeBiggerThanItsOwn() {
        int serverChunkSize = 1000;
        int clientChunkSize = serverChunkSize * 10;
        MadeUpServer server = this.builder.chunkSize(serverChunkSize).server();
        MadeUpClient client = this.builder.chunkSize(clientChunkSize).client();
        this.addToLifeAndStart(server, client);
        client.sendDataStream(new DataProducer(clientChunkSize * 2));
    }

    @Test
    public void impossibleToHaveBiggerChunkSizeThanFrameSize() throws Throwable {
        Builder myBuilder = this.builder.chunkSize(0x10000A);
        try {
            MadeUpServer server = myBuilder.server();
            server.init();
            server.start();
            Assert.fail((String)"Shouldn't be possible");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            myBuilder.client();
            Assert.fail((String)"Shouldn't be possible");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void clientShouldUseHandlersToHandleComExceptions() {
        String comExceptionMessage = "The ComException";
        MadeUpCommunicationInterface communication = (MadeUpCommunicationInterface)Mockito.mock(MadeUpCommunicationInterface.class, ingored -> {
            throw new ComException("The ComException");
        });
        ComExceptionHandler handler = (ComExceptionHandler)Mockito.mock(ComExceptionHandler.class);
        this.life.add((Lifecycle)this.builder.server(communication));
        MadeUpClient client = (MadeUpClient)this.life.add((Lifecycle)this.builder.client());
        client.setComExceptionHandler(handler);
        this.life.start();
        ComException exceptionThrownOnRequest = null;
        try {
            client.multiply(1, 10);
        }
        catch (ComException e) {
            exceptionThrownOnRequest = e;
        }
        Assert.assertNotNull((Object)((Object)exceptionThrownOnRequest));
        Assert.assertEquals((Object)"The ComException", (Object)exceptionThrownOnRequest.getMessage());
        ArgumentCaptor exceptionCaptor = ArgumentCaptor.forClass(ComException.class);
        ((ComExceptionHandler)Mockito.verify((Object)handler)).handle((ComException)((Object)exceptionCaptor.capture()));
        Assert.assertEquals((Object)"The ComException", (Object)((ComException)((Object)exceptionCaptor.getValue())).getMessage());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
    }

    @Test
    public void masterResponseShouldBeUnpackedIfRequestTypeRequires() throws Exception {
        ResponseUnpacker responseUnpacker = (ResponseUnpacker)Mockito.mock(ResponseUnpacker.class);
        MadeUpClient client = this.builder.clientWith(responseUnpacker);
        this.addToLifeAndStart(this.builder.server(), client);
        client.multiply(42, 42);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Response.class);
        ((ResponseUnpacker)Mockito.verify((Object)responseUnpacker)).unpackResponse((Response)captor.capture(), (ResponseUnpacker.TxHandler)ArgumentMatchers.eq((Object)ResponseUnpacker.TxHandler.NO_OP_TX_HANDLER));
        Assert.assertEquals((Object)this.storeIdToUse, (Object)((Response)captor.getValue()).getStoreId());
        Assert.assertEquals((Object)1764, (Object)((Response)captor.getValue()).response());
    }

    @Test
    public void masterResponseShouldNotBeUnpackedIfRequestTypeDoesNotRequire() {
        ResponseUnpacker responseUnpacker = (ResponseUnpacker)Mockito.mock(ResponseUnpacker.class);
        MadeUpClient client = this.builder.clientWith(responseUnpacker);
        this.addToLifeAndStart(this.builder.server(), client);
        client.sendDataStream(new KnownDataByteChannel(100));
        Mockito.verifyZeroInteractions((Object[])new Object[]{responseUnpacker});
    }

    @Test
    public void shouldStreamBackTransactions() throws Exception {
        int value = 11;
        int txCount = 5;
        this.life.add((Lifecycle)this.builder.server());
        MadeUpClient client = (MadeUpClient)this.life.add((Lifecycle)this.builder.client());
        this.life.start();
        Response<Integer> respone = client.streamBackTransactions(value, txCount);
        TransactionStreamVerifyingResponseHandler handler = new TransactionStreamVerifyingResponseHandler(txCount);
        respone.accept((Response.Handler)handler);
        int responseValue = (Integer)respone.response();
        Assert.assertEquals((long)value, (long)responseValue);
        Assert.assertEquals((long)txCount, (long)(handler.expectedTxId - 1L));
    }

    @Test
    public void shouldAdhereToTransactionObligations() throws Exception {
        int value = 15;
        long desiredObligation = 8L;
        this.life.add((Lifecycle)this.builder.server());
        MadeUpClient client = (MadeUpClient)this.life.add((Lifecycle)this.builder.client());
        this.life.start();
        Response<Integer> respone = client.informAboutTransactionObligations(value, desiredObligation);
        TransactionObligationVerifyingResponseHandler handler = new TransactionObligationVerifyingResponseHandler();
        respone.accept((Response.Handler)handler);
        int responseValue = (Integer)respone.response();
        Assert.assertEquals((long)value, (long)responseValue);
        Assert.assertEquals((long)desiredObligation, (long)handler.obligationTxId);
    }

    private void addToLifeAndStart(MadeUpServer server, MadeUpClient client) {
        this.life.add((Lifecycle)server);
        this.life.add((Lifecycle)client);
        this.life.init();
        this.life.start();
    }

    public class TransactionObligationVerifyingResponseHandler
    implements Response.Handler {
        volatile long obligationTxId;

        public void obligation(long txId) {
            this.obligationTxId = txId;
        }

        public Visitor<CommittedTransactionRepresentation, Exception> transactions() {
            throw new UnsupportedOperationException("Should not be called");
        }
    }

    public class TransactionStreamVerifyingResponseHandler
    implements Response.Handler,
    Visitor<CommittedTransactionRepresentation, Exception> {
        private final long txCount;
        private long expectedTxId = 1L;

        public TransactionStreamVerifyingResponseHandler(int txCount) {
            this.txCount = txCount;
        }

        public void obligation(long txId) {
            Assert.fail((String)"Should not called");
        }

        public Visitor<CommittedTransactionRepresentation, Exception> transactions() {
            return this;
        }

        public boolean visit(CommittedTransactionRepresentation element) {
            Assert.assertEquals((long)(this.expectedTxId + 1L), (long)element.getCommitEntry().getTxId());
            ++this.expectedTxId;
            Assert.assertThat((Object)element.getCommitEntry().getTxId(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(this.txCount + 1L)));
            return false;
        }
    }

    class Builder {
        private final int port;
        private final int chunkSize;
        private final byte internalProtocolVersion;
        private final byte applicationProtocolVersion;
        private final TxChecksumVerifier verifier;
        private final StoreId storeId;

        Builder() {
            this(PortAuthority.allocatePort(), 0x100000, 0, 0, TxChecksumVerifier.ALWAYS_MATCH, this$0.storeIdToUse);
        }

        Builder(int port, int chunkSize, byte internalProtocolVersion, byte applicationProtocolVersion, TxChecksumVerifier verifier, StoreId storeId) {
            this.port = port;
            this.chunkSize = chunkSize;
            this.internalProtocolVersion = internalProtocolVersion;
            this.applicationProtocolVersion = applicationProtocolVersion;
            this.verifier = verifier;
            this.storeId = storeId;
        }

        public Builder port(int port) {
            return new Builder(port, this.chunkSize, this.internalProtocolVersion, this.applicationProtocolVersion, this.verifier, this.storeId);
        }

        public Builder chunkSize(int chunkSize) {
            return new Builder(this.port, chunkSize, this.internalProtocolVersion, this.applicationProtocolVersion, this.verifier, this.storeId);
        }

        public Builder internalProtocolVersion(byte internalProtocolVersion) {
            return new Builder(this.port, this.chunkSize, internalProtocolVersion, this.applicationProtocolVersion, this.verifier, this.storeId);
        }

        public Builder applicationProtocolVersion(byte applicationProtocolVersion) {
            return new Builder(this.port, this.chunkSize, this.internalProtocolVersion, applicationProtocolVersion, this.verifier, this.storeId);
        }

        public Builder verifier(TxChecksumVerifier verifier) {
            return new Builder(this.port, this.chunkSize, this.internalProtocolVersion, this.applicationProtocolVersion, verifier, this.storeId);
        }

        public Builder storeId(StoreId storeId) {
            return new Builder(this.port, this.chunkSize, this.internalProtocolVersion, this.applicationProtocolVersion, this.verifier, storeId);
        }

        public MadeUpServer server() {
            return new MadeUpServer(new MadeUpServerImplementation(this.storeId), this.port, this.internalProtocolVersion, this.applicationProtocolVersion, this.verifier, this.chunkSize);
        }

        public MadeUpServer server(MadeUpCommunicationInterface target) {
            return new MadeUpServer(target, this.port, this.internalProtocolVersion, this.applicationProtocolVersion, this.verifier, this.chunkSize);
        }

        public MadeUpClient client() {
            return this.clientWith(ResponseUnpacker.NO_OP_RESPONSE_UNPACKER);
        }

        public MadeUpClient clientWith(ResponseUnpacker responseUnpacker) {
            return new MadeUpClient(this.port, this.storeId, this.chunkSize, responseUnpacker){

                public ProtocolVersion getProtocolVersion() {
                    return new ProtocolVersion(Builder.this.applicationProtocolVersion, Builder.this.internalProtocolVersion);
                }
            };
        }

        public ServerInterface serverInOtherJvm() {
            ServerInterface server = (ServerInterface)new MadeUpServerProcess().start(new StartupData(this.storeId.getCreationTime(), this.storeId.getRandomId(), this.internalProtocolVersion, this.applicationProtocolVersion, this.chunkSize));
            server.awaitStarted();
            return server;
        }
    }
}

