/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.com.DataProducer;
import org.neo4j.com.storecopy.StoreCopyClientMonitor;
import org.neo4j.com.storecopy.ToFileStoreWriter;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class ToFileStoreWriterTest {
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final TestDirectory directory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.directory).around((TestRule)this.pageCacheRule);

    @Test
    public void shouldLetPageCacheHandleRecordStoresAndNativeLabelScanStoreFiles() throws Exception {
        ArrayList actions = new ArrayList();
        PageCache pageCache = (PageCache)Mockito.spy((Object)this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs));
        ToFileStoreWriter writer = new ToFileStoreWriter(this.directory.absolutePath(), (FileSystemAbstraction)this.fs, (StoreCopyClientMonitor)new StoreCopyClientMonitor.Adapter(), pageCache, actions);
        ByteBuffer tempBuffer = ByteBuffer.allocate(128);
        for (StoreType type : StoreType.values()) {
            if (!type.isRecordStore()) continue;
            String fileName = type.getStoreFile().fileName(StoreFileType.STORE);
            this.writeAndVerifyWrittenThroughPageCache(pageCache, writer, tempBuffer, fileName);
        }
        this.writeAndVerifyWrittenThroughPageCache(pageCache, writer, tempBuffer, "neostore.labelscanstore.db");
    }

    @Test
    public void fullPathFileNamesUsedForMonitoringBackup() throws IOException {
        final AtomicBoolean wasActivated = new AtomicBoolean(false);
        StoreCopyClientMonitor.Adapter monitor = new StoreCopyClientMonitor.Adapter(){

            public void startReceivingStoreFile(String file) {
                Assert.assertTrue((boolean)file.contains("expectedFileName"));
                wasActivated.set(true);
            }
        };
        ArrayList actions = new ArrayList();
        PageCache pageCache = (PageCache)Mockito.spy((Object)this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs));
        ToFileStoreWriter writer = new ToFileStoreWriter(this.directory.absolutePath(), (FileSystemAbstraction)this.fs, (StoreCopyClientMonitor)monitor, pageCache, actions);
        ByteBuffer tempBuffer = ByteBuffer.allocate(128);
        writer.write("expectedFileName", (ReadableByteChannel)new DataProducer(16), tempBuffer, true, 16);
        Assert.assertTrue((boolean)wasActivated.get());
    }

    private void writeAndVerifyWrittenThroughPageCache(PageCache pageCache, ToFileStoreWriter writer, ByteBuffer tempBuffer, String fileName) throws IOException {
        File expected = new File(this.directory.absolutePath(), fileName);
        writer.write(fileName, (ReadableByteChannel)new DataProducer(16), tempBuffer, true, 16);
        ((PageCache)Mockito.verify((Object)pageCache)).map((File)ArgumentMatchers.eq((Object)expected), ArgumentMatchers.anyInt(), (OpenOption[])ArgumentMatchers.any());
    }
}

