/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import org.neo4j.com.Response;
import org.neo4j.com.storecopy.BatchingResponseHandler;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.TransactionBatchCommitter;
import org.neo4j.com.storecopy.TransactionObligationFulfiller;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.storageengine.api.StorageEngine;

public class TransactionCommittingResponseUnpacker
extends LifecycleAdapter
implements ResponseUnpacker {
    public static final int DEFAULT_BATCH_SIZE = 100;
    private final Dependencies dependencies;
    private final int maxBatchSize;
    private final long idReuseSafeZoneTime;
    private TransactionObligationFulfiller obligationFulfiller;
    private TransactionBatchCommitter batchCommitter;
    private VersionContextSupplier versionContextSupplier;
    private Log log;
    private volatile boolean stopped;

    public TransactionCommittingResponseUnpacker(DependencyResolver dependencies, int maxBatchSize, long idReuseSafeZoneTime) {
        this(new ResolvableDependencies(dependencies), maxBatchSize, idReuseSafeZoneTime);
    }

    public TransactionCommittingResponseUnpacker(Dependencies dependencies, int maxBatchSize, long idReuseSafeZoneTime) {
        this.dependencies = dependencies;
        this.maxBatchSize = maxBatchSize;
        this.idReuseSafeZoneTime = idReuseSafeZoneTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpackResponse(Response<?> response, ResponseUnpacker.TxHandler txHandler) throws Exception {
        if (this.stopped) {
            throw new IllegalStateException("Component is currently stopped");
        }
        BatchingResponseHandler responseHandler = new BatchingResponseHandler(this.maxBatchSize, this.batchCommitter, this.obligationFulfiller, txHandler, this.versionContextSupplier, this.log);
        try {
            response.accept(responseHandler);
        }
        finally {
            responseHandler.applyQueuedTransactions();
        }
    }

    public void start() {
        this.obligationFulfiller = this.dependencies.obligationFulfiller();
        this.log = this.dependencies.logService().getInternalLog(BatchingResponseHandler.class);
        this.versionContextSupplier = this.dependencies.versionContextSupplier();
        this.batchCommitter = new TransactionBatchCommitter(this.dependencies.kernelTransactions(), this.idReuseSafeZoneTime, this.dependencies.commitProcess(), this.log);
        this.stopped = false;
    }

    public void stop() {
        this.stopped = true;
    }

    private static class ResolvableDependencies
    implements Dependencies {
        private final DependencyResolver resolver;

        ResolvableDependencies(DependencyResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public TransactionCommitProcess commitProcess() {
            return new TransactionRepresentationCommitProcess((TransactionAppender)this.resolver.resolveDependency(TransactionAppender.class), (StorageEngine)this.resolver.resolveDependency(StorageEngine.class));
        }

        @Override
        public TransactionObligationFulfiller obligationFulfiller() {
            try {
                return (TransactionObligationFulfiller)this.resolver.resolveDependency(TransactionObligationFulfiller.class);
            }
            catch (UnsatisfiedDependencyException e) {
                return toTxId -> {
                    throw new UnsupportedOperationException("Should not be called");
                };
            }
        }

        @Override
        public LogService logService() {
            return (LogService)this.resolver.resolveDependency(LogService.class);
        }

        @Override
        public KernelTransactions kernelTransactions() {
            return (KernelTransactions)this.resolver.resolveDependency(KernelTransactions.class);
        }

        @Override
        public VersionContextSupplier versionContextSupplier() {
            return (VersionContextSupplier)this.resolver.resolveDependency(VersionContextSupplier.class);
        }
    }

    public static interface Dependencies {
        public TransactionCommitProcess commitProcess();

        public TransactionObligationFulfiller obligationFulfiller();

        public LogService logService();

        public KernelTransactions kernelTransactions();

        public VersionContextSupplier versionContextSupplier();
    }
}

