/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.neo4j.graphdb.Resource;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.FileIsNotMappedException;
import org.neo4j.kernel.impl.pagecache.PageLoader;
import org.neo4j.kernel.impl.pagecache.PageLoaderFactory;
import org.neo4j.kernel.impl.pagecache.Profile;
import org.neo4j.kernel.impl.pagecache.ProfileRefCounts;
import org.neo4j.kernel.impl.transaction.state.NeoStoreFileListing;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StoreFileMetadata;

public class PageCacheWarmer
implements NeoStoreFileListing.StoreFileProvider {
    public static final String SUFFIX_CACHEPROF = ".cacheprof";
    private static final int IO_PARALLELISM = Runtime.getRuntime().availableProcessors();
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final JobScheduler scheduler;
    private final ProfileRefCounts refCounts;
    private volatile boolean stopped;
    private ExecutorService executor;
    private PageLoaderFactory pageLoaderFactory;

    PageCacheWarmer(FileSystemAbstraction fs, PageCache pageCache, JobScheduler scheduler) {
        this.fs = fs;
        this.pageCache = pageCache;
        this.scheduler = scheduler;
        this.refCounts = new ProfileRefCounts();
    }

    public synchronized Resource addFilesTo(Collection<StoreFileMetadata> coll) throws IOException {
        Profile[] existingProfiles;
        if (this.stopped) {
            return Resource.EMPTY;
        }
        List files = this.pageCache.listExistingMappings();
        for (Profile profile : existingProfiles = this.findExistingProfiles(files)) {
            coll.add(new StoreFileMetadata(profile.file(), 1, false));
        }
        this.refCounts.incrementRefCounts(existingProfiles);
        return () -> this.refCounts.decrementRefCounts(existingProfiles);
    }

    public synchronized void start() {
        this.stopped = false;
        this.executor = this.buildExecutorService(this.scheduler);
        this.pageLoaderFactory = new PageLoaderFactory(this.executor, this.pageCache);
    }

    public void stop() {
        this.stopped = true;
        this.stopWarmer();
    }

    private synchronized void stopWarmer() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    synchronized OptionalLong reheat() throws IOException {
        if (this.stopped) {
            return OptionalLong.empty();
        }
        long pagesLoaded = 0L;
        List files = this.pageCache.listExistingMappings();
        Profile[] existingProfiles = this.findExistingProfiles(files);
        for (PagedFile file : files) {
            try {
                pagesLoaded += this.reheat(file, existingProfiles);
            }
            catch (FileIsNotMappedException fileIsNotMappedException) {}
        }
        return OptionalLong.of(pagesLoaded);
    }

    public synchronized OptionalLong profile() throws IOException {
        if (this.stopped) {
            return OptionalLong.empty();
        }
        long pagesInMemory = 0L;
        List files = this.pageCache.listExistingMappings();
        Profile[] existingProfiles = this.findExistingProfiles(files);
        for (PagedFile file : files) {
            try {
                pagesInMemory += this.profile(file, existingProfiles);
            }
            catch (FileIsNotMappedException fileIsNotMappedException) {
                // empty catch block
            }
            if (!this.stopped) continue;
            this.pageCache.reportEvents();
            return OptionalLong.empty();
        }
        this.pageCache.reportEvents();
        return OptionalLong.of(pagesInMemory);
    }

    private long reheat(PagedFile file, Profile[] existingProfiles) throws IOException {
        Optional<Profile> savedProfile = this.filterRelevant(existingProfiles, file).sorted(Comparator.reverseOrder()).filter(this::verifyChecksum).findFirst();
        if (!savedProfile.isPresent()) {
            return 0L;
        }
        long pagesLoaded = 0L;
        try (InputStream input = savedProfile.get().read(this.fs);
             PageLoader loader = this.pageLoaderFactory.getLoader(file);){
            int b;
            long pageId = 0L;
            while ((b = input.read()) != -1) {
                for (int i = 0; i < 8; ++i) {
                    if (this.stopped) {
                        this.pageCache.reportEvents();
                        long l = pagesLoaded;
                        return l;
                    }
                    if ((b & 1) == 1) {
                        loader.load(pageId);
                        ++pagesLoaded;
                    }
                    b >>= 1;
                    ++pageId;
                }
            }
        }
        this.pageCache.reportEvents();
        return pagesLoaded;
    }

    private boolean verifyChecksum(Profile profile) {
        try (InputStream input = profile.read(this.fs);){
            int b;
            while ((b = input.read()) != -1) {
            }
        }
        catch (IOException ignore) {
            return false;
        }
        return true;
    }

    private long profile(PagedFile file, Profile[] existingProfiles) throws IOException {
        long pagesInMemory = 0L;
        Profile nextProfile = this.filterRelevant(existingProfiles, file).max(Comparator.naturalOrder()).map(Profile::next).orElse(Profile.first(file.file()));
        try (OutputStream output = nextProfile.write(this.fs);
             PageCursor cursor = file.io(0L, 17);){
            int stepper = 0;
            int b = 0;
            while (cursor.next()) {
                if (cursor.getCurrentPageId() != -1L) {
                    ++pagesInMemory;
                    b |= 1 << stepper;
                }
                if (++stepper != 8) continue;
                output.write(b);
                b = 0;
                stepper = 0;
            }
            output.write(b);
            output.flush();
        }
        this.filterRelevant(existingProfiles, file).filter(profile -> !this.refCounts.contains((Profile)profile)).forEach(profile -> profile.delete(this.fs));
        return pagesInMemory;
    }

    private ExecutorService buildExecutorService(JobScheduler scheduler) {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(IO_PARALLELISM * 4);
        ThreadPoolExecutor.CallerRunsPolicy rejectionPolicy = new ThreadPoolExecutor.CallerRunsPolicy();
        ThreadFactory threadFactory = scheduler.threadFactory(JobScheduler.Groups.pageCacheIOHelper);
        return new ThreadPoolExecutor(0, IO_PARALLELISM, 10L, TimeUnit.SECONDS, workQueue, threadFactory, rejectionPolicy);
    }

    private Stream<Profile> filterRelevant(Profile[] profiles, PagedFile pagedFile) {
        return Stream.of(profiles).filter(Profile.relevantTo(pagedFile));
    }

    private Profile[] findExistingProfiles(List<PagedFile> pagedFiles) {
        return (Profile[])pagedFiles.stream().map(pf -> pf.file().getParentFile()).distinct().flatMap(dir -> Profile.findProfilesInDirectory(this.fs, dir)).toArray(Profile[]::new);
    }
}

