/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com;

import java.util.function.Supplier;
import org.neo4j.com.RequestContext;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class RequestContextFactory
extends LifecycleAdapter {
    private long epoch;
    private final int serverId;
    private final Supplier<TransactionIdStore> txIdStoreSupplier;
    private TransactionIdStore txIdStore;
    public static final int DEFAULT_EVENT_IDENTIFIER = -1;

    public RequestContextFactory(int serverId, Supplier<TransactionIdStore> txIdStoreSupplier) {
        this.txIdStoreSupplier = txIdStoreSupplier;
        this.epoch = -1L;
        this.serverId = serverId;
    }

    public void start() {
        this.txIdStore = this.txIdStoreSupplier.get();
    }

    public void stop() {
        this.txIdStore = null;
    }

    public void setEpoch(long epoch) {
        this.epoch = epoch;
    }

    public RequestContext newRequestContext(long epoch, int machineId, int eventIdentifier) {
        TransactionId lastTx = this.txIdStore.getLastCommittedTransaction();
        return new RequestContext(epoch, machineId, eventIdentifier, lastTx.transactionId(), lastTx.checksum());
    }

    public RequestContext newRequestContext(int eventIdentifier) {
        return this.newRequestContext(this.epoch, this.serverId, eventIdentifier);
    }

    public RequestContext newRequestContext() {
        return this.newRequestContext(-1);
    }
}

