/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.mem;

import org.neo4j.io.os.OsBeanUtil;

public class NativeMemoryAllocationRefusedError
extends OutOfMemoryError {
    private final long attemptedAllocationSizeBytes;
    private final long alreadyAllocatedBytes;

    NativeMemoryAllocationRefusedError(long size, long alreadyAllocatedBytes) {
        this.attemptedAllocationSizeBytes = size;
        this.alreadyAllocatedBytes = alreadyAllocatedBytes;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to allocate ").append(this.attemptedAllocationSizeBytes).append(" bytes. ");
        sb.append("So far ").append(this.alreadyAllocatedBytes);
        sb.append(" bytes have already been successfully allocated. ");
        sb.append("The system currently has ");
        this.appendBytes(sb, OsBeanUtil.getTotalPhysicalMemory()).append(" total physical memory, ");
        this.appendBytes(sb, OsBeanUtil.getCommittedVirtualMemory()).append(" committed virtual memory, and ");
        this.appendBytes(sb, OsBeanUtil.getFreePhysicalMemory()).append(" free physical memory. ");
        sb.append("The allocation was refused by the operating system");
        if (message != null) {
            sb.append(": ").append(message);
        } else {
            sb.append('.');
        }
        return sb.toString();
    }

    private StringBuilder appendBytes(StringBuilder sb, long bytes) {
        if (bytes == -1L) {
            sb.append("(?) bytes");
        } else {
            sb.append(bytes).append(" bytes");
        }
        return sb;
    }
}

