/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.inmemory.UpdateCapturingIndexUpdater;
import org.neo4j.storageengine.api.schema.IndexReader;

public class UpdateCapturingIndexAccessor
implements IndexAccessor {
    private final IndexAccessor actual;
    private final Collection<IndexEntryUpdate<?>> updates = new ArrayList();

    public UpdateCapturingIndexAccessor(IndexAccessor actual, Collection<IndexEntryUpdate<?>> initialUpdates) {
        this.actual = actual;
        if (initialUpdates != null) {
            this.updates.addAll(initialUpdates);
        }
    }

    public void drop() throws IOException {
        this.actual.drop();
    }

    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        return this.wrap(this.actual.newUpdater(mode));
    }

    private IndexUpdater wrap(IndexUpdater actual) {
        return new UpdateCapturingIndexUpdater(actual, this.updates);
    }

    public void force(IOLimiter ioLimiter) throws IOException {
        this.actual.force(ioLimiter);
    }

    public void refresh() throws IOException {
        this.actual.refresh();
    }

    public void close() throws IOException {
        this.actual.close();
    }

    public IndexReader newReader() {
        return this.actual.newReader();
    }

    public BoundedIterable<Long> newAllEntriesReader() {
        return this.actual.newAllEntriesReader();
    }

    public ResourceIterator<File> snapshotFiles() throws IOException {
        return this.actual.snapshotFiles();
    }

    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
        this.actual.verifyDeferredConstraints(propertyAccessor);
    }

    public boolean isDirty() {
        return this.actual.isDirty();
    }

    public Collection<IndexEntryUpdate<?>> snapshot() {
        return new ArrayList(this.updates);
    }
}

