/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.test.DoubleLatch;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NodeGetUniqueFromIndexSeekIT
extends KernelIntegrationTest {
    private int labelId;
    private int propertyId1;
    private int propertyId2;

    @Before
    public void createKeys() throws Exception {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        this.labelId = tokenWrite.labelGetOrCreateForName("Person");
        this.propertyId1 = tokenWrite.propertyKeyGetOrCreateForName("foo");
        this.propertyId2 = tokenWrite.propertyKeyGetOrCreateForName("bar");
        this.commit();
    }

    @Test
    public void shouldFindMatchingNode() throws Exception {
        CapableIndexReference index = this.createUniquenessConstraint(this.labelId, this.propertyId1);
        Value value = Values.of((Object)"value");
        long nodeId = this.createNodeWithValue(value);
        Read read = this.newTransaction().dataRead();
        int propertyId = index.properties()[0];
        long foundId = read.lockingNodeUniqueIndexSeek((IndexReference)index, new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)propertyId, (Object)value)});
        this.commit();
        Assert.assertTrue((String)"Created node was not found", (nodeId == foundId ? 1 : 0) != 0);
    }

    @Test
    public void shouldNotFindNonMatchingNode() throws Exception {
        CapableIndexReference index = this.createUniquenessConstraint(this.labelId, this.propertyId1);
        Value value = Values.of((Object)"value");
        this.createNodeWithValue(Values.of((Object)("other_" + value)));
        Transaction transaction = this.newTransaction();
        long foundId = transaction.dataRead().lockingNodeUniqueIndexSeek((IndexReference)index, new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)this.propertyId1, (Object)value)});
        this.commit();
        Assert.assertTrue((String)"Non-matching created node was found", (boolean)this.isNoSuchNode(foundId));
    }

    @Test
    public void shouldCompositeFindMatchingNode() throws Exception {
        CapableIndexReference index = this.createUniquenessConstraint(this.labelId, this.propertyId1, this.propertyId2);
        Value value1 = Values.of((Object)"value1");
        Value value2 = Values.of((Object)"value2");
        long nodeId = this.createNodeWithValues(value1, value2);
        Transaction transaction = this.newTransaction();
        long foundId = transaction.dataRead().lockingNodeUniqueIndexSeek((IndexReference)index, new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)this.propertyId1, (Object)value1), IndexQuery.exact((int)this.propertyId2, (Object)value2)});
        this.commit();
        Assert.assertTrue((String)"Created node was not found", (nodeId == foundId ? 1 : 0) != 0);
    }

    @Test
    public void shouldNotCompositeFindNonMatchingNode() throws Exception {
        CapableIndexReference index = this.createUniquenessConstraint(this.labelId, this.propertyId1, this.propertyId2);
        Value value1 = Values.of((Object)"value1");
        Value value2 = Values.of((Object)"value2");
        this.createNodeWithValues(Values.of((Object)("other_" + value1)), Values.of((Object)("other_" + value2)));
        Transaction transaction = this.newTransaction();
        long foundId = transaction.dataRead().lockingNodeUniqueIndexSeek((IndexReference)index, new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)this.propertyId1, (Object)value1), IndexQuery.exact((int)this.propertyId2, (Object)value2)});
        this.commit();
        Assert.assertTrue((String)"Non-matching created node was found", (boolean)this.isNoSuchNode(foundId));
    }

    @Test(timeout=10000L)
    public void shouldBlockUniqueIndexSeekFromCompetingTransaction() throws Exception {
        DoubleLatch latch = new DoubleLatch();
        CapableIndexReference index = this.createUniquenessConstraint(this.labelId, this.propertyId1);
        Value value = Values.of((Object)"value");
        Write write = this.dataWriteInNewTransaction();
        long nodeId = write.nodeCreate();
        write.nodeAddLabel(nodeId, this.labelId);
        write.nodeSetProperty(nodeId, this.propertyId1, value);
        Runnable runnableForThread2 = () -> {
            latch.waitForAllToStart();
            try (Transaction tx = this.session.beginTransaction();){
                tx.dataRead().lockingNodeUniqueIndexSeek((IndexReference)index, new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)this.propertyId1, (Object)value)});
                tx.success();
            }
            catch (KernelException e) {
                throw new RuntimeException(e);
            }
            finally {
                latch.finish();
            }
        };
        Thread thread2 = new Thread(runnableForThread2, "Transaction Thread 2");
        thread2.start();
        latch.startAndWaitForAllToStart();
        while (thread2.getState() != Thread.State.TIMED_WAITING && thread2.getState() != Thread.State.WAITING) {
            Thread.yield();
        }
        this.commit();
        latch.waitForAllToFinish();
    }

    private boolean isNoSuchNode(long foundId) {
        return -1L == foundId;
    }

    private long createNodeWithValue(Value value) throws KernelException {
        Write write = this.dataWriteInNewTransaction();
        long nodeId = write.nodeCreate();
        write.nodeAddLabel(nodeId, this.labelId);
        write.nodeSetProperty(nodeId, this.propertyId1, value);
        this.commit();
        return nodeId;
    }

    private long createNodeWithValues(Value value1, Value value2) throws KernelException {
        Write write = this.dataWriteInNewTransaction();
        long nodeId = write.nodeCreate();
        write.nodeAddLabel(nodeId, this.labelId);
        write.nodeSetProperty(nodeId, this.propertyId1, value1);
        write.nodeSetProperty(nodeId, this.propertyId2, value2);
        this.commit();
        return nodeId;
    }

    private CapableIndexReference createUniquenessConstraint(int labelId, int ... propertyIds) throws Exception {
        Transaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)labelId, (int[])propertyIds);
        transaction.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)descriptor);
        CapableIndexReference result = transaction.schemaRead().index(descriptor.getLabelId(), descriptor.getPropertyIds());
        this.commit();
        return result;
    }
}

