/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.io.File;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.subprocess.SubProcess;

public class SchemaRecoveryIT {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();

    @Test
    public void schemaTransactionsShouldSurviveRecovery() throws Exception {
        File storeDir = this.testDirectory.absolutePath();
        Process process = (Process)new CreateConstraintButDoNotShutDown().start(storeDir);
        process.waitForSchemaTransactionCommitted();
        SubProcess.kill(process);
        GraphDatabaseService recoveredDatabase = new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
        Assert.assertEquals((long)1L, (long)this.constraints(recoveredDatabase).size());
        Assert.assertEquals((long)1L, (long)this.indexes(recoveredDatabase).size());
        recoveredDatabase.shutdown();
    }

    private List<ConstraintDefinition> constraints(GraphDatabaseService database) {
        try (Transaction ignored = database.beginTx();){
            List list = Iterables.asList((Iterable)database.schema().getConstraints());
            return list;
        }
    }

    private List<IndexDefinition> indexes(GraphDatabaseService database) {
        try (Transaction ignored = database.beginTx();){
            List list = Iterables.asList((Iterable)database.schema().getIndexes());
            return list;
        }
    }

    static class CreateConstraintButDoNotShutDown
    extends SubProcess<Process, File>
    implements Process {
        private volatile boolean started;

        CreateConstraintButDoNotShutDown() {
        }

        @Override
        protected void startup(File storeDir) {
            GraphDatabaseService database = new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
            try (Transaction transaction = database.beginTx();){
                database.schema().constraintFor(Label.label((String)"User")).assertPropertyIsUnique("uuid").create();
                transaction.success();
            }
            this.started = true;
        }

        @Override
        public void waitForSchemaTransactionCommitted() throws InterruptedException {
            while (!this.started) {
                Thread.sleep(10L);
            }
        }
    }

    public static interface Process {
        public void waitForSchemaTransactionCommitted() throws InterruptedException;
    }
}

