/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.GraphTransactionRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class GraphPropertiesProxyTest {
    @ClassRule
    public static DatabaseRule db = new ImpermanentDatabaseRule();
    @Rule
    public GraphTransactionRule tx = new GraphTransactionRule(db);

    @Test
    public void testGraphAddPropertyWithNullKey() {
        try {
            this.graphProperties().setProperty(null, (Object)"bar");
            Assert.fail((String)"Null key should result in exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGraphAddPropertyWithNullValue() {
        try {
            this.graphProperties().setProperty("foo", null);
            Assert.fail((String)"Null value should result in exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.tx.failure();
    }

    private GraphProperties graphProperties() {
        return ((EmbeddedProxySPI)db.getDependencyResolver().resolveDependency(EmbeddedProxySPI.class)).newGraphPropertiesProxy();
    }
}

