/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.allocator;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.allocator.ReusableRecordsCompositeAllocator;
import org.neo4j.kernel.impl.store.record.DynamicRecord;

public class ReusableRecordsCompositeAllocatorTest {
    @Test
    public void allocateReusableRecordsAndSwitchToDefaultWhenExhausted() {
        DynamicRecord dynamicRecord1 = new DynamicRecord(1L);
        DynamicRecord dynamicRecord2 = new DynamicRecord(2L);
        DynamicRecordAllocator recordAllocator = (DynamicRecordAllocator)Mockito.mock(DynamicRecordAllocator.class);
        Mockito.when((Object)recordAllocator.nextRecord()).thenReturn((Object)dynamicRecord2);
        ReusableRecordsCompositeAllocator compositeAllocator = new ReusableRecordsCompositeAllocator(Collections.singletonList(dynamicRecord1), recordAllocator);
        Assert.assertSame((String)"Same as pre allocated record.", (Object)dynamicRecord1, (Object)compositeAllocator.nextRecord());
        Assert.assertSame((String)"Same as expected allocated record.", (Object)dynamicRecord2, (Object)compositeAllocator.nextRecord());
    }
}

