/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.StoreFile;
import org.neo4j.kernel.impl.store.format.StoreVersion;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.storemigration.participant.CountsMigrator;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.kernel.impl.util.monitoring.SilentProgressReporter;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class CountsMigratorTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);

    @Test
    public void shouldNotAccidentallyDeleteStoreFilesIfNoMigrationWasRequired() throws IOException {
        CountsMigrator migrator = new CountsMigrator((FileSystemAbstraction)this.fs, null, Config.defaults());
        File storeDir = this.directory.graphDbDir();
        File countsStoreFileA = new File(storeDir, StoreFile.COUNTS_STORE_LEFT.fileName(StoreFileType.STORE));
        File countsStoreFileB = new File(storeDir, StoreFile.COUNTS_STORE_RIGHT.fileName(StoreFileType.STORE));
        this.fs.create(countsStoreFileA);
        this.fs.create(countsStoreFileB);
        File migrationDir = new File(storeDir, "migration");
        this.fs.mkdirs(migrationDir);
        String versionToMigrateFrom = StoreVersion.STANDARD_V3_2.versionString();
        String versionToMigrateTo = StoreVersion.STANDARD_V3_4.versionString();
        migrator.migrate(storeDir, migrationDir, (ProgressReporter)SilentProgressReporter.INSTANCE, versionToMigrateFrom, versionToMigrateTo);
        Assert.assertEquals((String)"Invalid test assumption: There should not have been migration for those versions", (long)0L, (long)this.fs.listFiles(migrationDir).length);
        migrator.moveMigratedFiles(migrationDir, storeDir, versionToMigrateFrom, versionToMigrateTo);
        Assert.assertTrue((boolean)this.fs.fileExists(countsStoreFileA));
        Assert.assertTrue((boolean)this.fs.fileExists(countsStoreFileB));
    }
}

